/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;

public class AndroidDependenciesCache {
    private static final Key<SoftReference<AndroidDependenciesCache>> KEY = Key.create((String)"ANDROID_DEPENDENCIES_CACHE");
    private final Module myModule;
    private final Ref<List<WeakReference<AndroidFacet>>> myAllDependencies = Ref.create();
    private final Ref<List<WeakReference<AndroidFacet>>> myAllLibraryDependencies = Ref.create();

    private AndroidDependenciesCache(Module module) {
        this.myModule = module;
        module.getProject().getMessageBus().connect((Disposable)module).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                AndroidDependenciesCache.this.dropCache();
            }
        });
    }

    private synchronized void dropCache() {
        this.myAllDependencies.set(null);
        this.myAllLibraryDependencies.set(null);
    }

    public static AndroidDependenciesCache getInstance(Module module) {
        AndroidDependenciesCache cache = (AndroidDependenciesCache)SoftReference.dereference((Reference)((Reference)module.getUserData(KEY)));
        if (cache == null) {
            cache = new AndroidDependenciesCache(module);
            module.putUserData(KEY, (Object)new SoftReference((Object)cache));
        }
        return cache;
    }

    public synchronized List<AndroidFacet> getAllAndroidDependencies(boolean androidLibrariesOnly) {
        return AndroidDependenciesCache.getAllAndroidDependencies(this.myModule, androidLibrariesOnly, this.getListRef(androidLibrariesOnly));
    }

    private Ref<List<WeakReference<AndroidFacet>>> getListRef(boolean androidLibrariesOnly) {
        return androidLibrariesOnly ? this.myAllLibraryDependencies : this.myAllDependencies;
    }

    private static List<AndroidFacet> getAllAndroidDependencies(Module module, boolean androidLibrariesOnly, Ref<List<WeakReference<AndroidFacet>>> listRef) {
        List refs = (List)listRef.get();
        if (refs == null) {
            ArrayList<AndroidFacet> facets = new ArrayList<AndroidFacet>();
            AndroidDependenciesCache.collectAllAndroidDependencies(module, androidLibrariesOnly, facets, (Set<AndroidFacet>)new HashSet());
            refs = ContainerUtil.map((Collection)ContainerUtil.reverse(facets), (Function)new Function<AndroidFacet, WeakReference<AndroidFacet>>(){

                public WeakReference<AndroidFacet> fun(AndroidFacet facet) {
                    return new WeakReference<AndroidFacet>(facet);
                }
            });
            listRef.set((Object)refs);
        }
        return AndroidDependenciesCache.dereference(refs);
    }

    private static List<AndroidFacet> dereference(List<WeakReference<AndroidFacet>> refs) {
        return ContainerUtil.mapNotNull(refs, (Function)new Function<WeakReference<AndroidFacet>, AndroidFacet>(){

            public AndroidFacet fun(WeakReference<AndroidFacet> ref) {
                return (AndroidFacet)((Object)ref.get());
            }
        });
    }

    private static void collectAllAndroidDependencies(Module module, boolean androidLibrariesOnly, List<AndroidFacet> result, Set<AndroidFacet> visited) {
        OrderEntry[] entries = ModuleRootManager.getInstance((Module)module).getOrderEntries();
        for (int i = entries.length - 1; i >= 0; --i) {
            AndroidFacet depFacet;
            Module depModule;
            ModuleOrderEntry moduleOrderEntry;
            OrderEntry orderEntry = entries[i];
            if (!(orderEntry instanceof ModuleOrderEntry) || (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getScope() != DependencyScope.COMPILE || (depModule = moduleOrderEntry.getModule()) == null || (depFacet = AndroidFacet.getInstance(depModule)) == null || androidLibrariesOnly && !depFacet.isLibraryProject() || !visited.add(depFacet)) continue;
            List cachedDepDeps = (List)AndroidDependenciesCache.getInstance(depModule).getListRef(androidLibrariesOnly).get();
            if (cachedDepDeps != null) {
                List<AndroidFacet> depDeps = AndroidDependenciesCache.dereference(cachedDepDeps);
                for (AndroidFacet depDepFacet : depDeps) {
                    if (!visited.add(depDepFacet)) continue;
                    result.add(depDepFacet);
                }
            } else {
                AndroidDependenciesCache.collectAllAndroidDependencies(depModule, androidLibrariesOnly, result, visited);
            }
            result.add(depFacet);
        }
    }
}

