/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.tree.java.IKeywordElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.run.AndroidRunConfiguration;
import org.jetbrains.android.run.AndroidRunConfigurationBase;
import org.jetbrains.android.run.AndroidRunConfigurationType;
import org.jetbrains.android.run.TargetSelectionMode;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidDependenciesCache;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.android.util.ExecutionStatus;
import org.jetbrains.android.util.OutputProcessor;
import org.jetbrains.android.util.WaitingStrategies;
import org.jetbrains.annotations.NonNls;

public class AndroidUtils {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.util.AndroidUtils");
    @NonNls
    public static final String NAMESPACE_KEY = "android";
    @NonNls
    public static final String SYSTEM_RESOURCE_PACKAGE = "android";
    @NonNls
    public static final String VIEW_CLASS_NAME = "android.view.View";
    @NonNls
    public static final String APPLICATION_CLASS_NAME = "android.app.Application";
    @NonNls
    public static final String ACTIVITY_BASE_CLASS_NAME = "android.app.Activity";
    @NonNls
    public static final String R_CLASS_NAME = "R";
    @NonNls
    public static final String MANIFEST_CLASS_NAME = "Manifest";
    @NonNls
    public static final String LAUNCH_ACTION_NAME = "android.intent.action.MAIN";
    @NonNls
    public static final String WALLPAPER_SERVICE_ACTION_NAME = "android.service.wallpaper.WallpaperService";
    @NonNls
    public static final String LAUNCH_CATEGORY_NAME = "android.intent.category.LAUNCHER";
    @NonNls
    public static final String LEANBACK_LAUNCH_CATEGORY_NAME = "android.intent.category.LEANBACK_LAUNCHER";
    @NonNls
    public static final String DEFAULT_CATEGORY_NAME = "android.intent.category.DEFAULT";
    @NonNls
    public static final String WATCHFACE_CATEGORY_NAME = "com.google.android.wearable.watchface.category.WATCH_FACE";
    @NonNls
    public static final String INSTRUMENTATION_RUNNER_BASE_CLASS = "android.app.Instrumentation";
    @NonNls
    public static final String SERVICE_CLASS_NAME = "android.app.Service";
    @NonNls
    public static final String RECEIVER_CLASS_NAME = "android.content.BroadcastReceiver";
    @NonNls
    public static final String PROVIDER_CLASS_NAME = "android.content.ContentProvider";
    public static final int TIMEOUT = 3000000;
    public static final int MAX_RETRIES = 5;
    private static final Key<ConsoleView> CONSOLE_VIEW_KEY = new Key("AndroidConsoleView");
    @NonNls
    public static final String ANDROID_LIBRARY_PROPERTY = "android.library";
    @NonNls
    public static final String ANDROID_MANIFEST_MERGER_PROPERTY = "manifestmerger.enabled";
    @NonNls
    public static final String ANDROID_DEX_DISABLE_MERGER = "dex.disable.merger";
    @NonNls
    public static final String ANDROID_DEX_FORCE_JUMBO_PROPERTY = "dex.force.jumbo";
    @NonNls
    public static final String ANDROID_TARGET_PROPERTY = "target";
    @NonNls
    public static final String ANDROID_LIBRARY_REFERENCE_PROPERTY_PREFIX = "android.library.reference.";
    @NonNls
    public static final String TAG_LINEAR_LAYOUT = "LinearLayout";
    private static final String[] ANDROID_COMPONENT_CLASSES = new String[]{"android.app.Activity", "android.app.Service", "android.content.BroadcastReceiver", "android.content.ContentProvider"};

    private AndroidUtils() {
    }

    public static <T extends DomElement> T loadDomElement(Module module, VirtualFile file, Class<T> aClass) {
        return AndroidUtils.loadDomElement(module.getProject(), file, aClass);
    }

    public static <T extends DomElement> T loadDomElement(final Project project, final VirtualFile file, final Class<T> aClass) {
        return (T)((DomElement)ApplicationManager.getApplication().runReadAction(new Computable<T>(){

            public T compute() {
                if (project.isDisposed()) {
                    return null;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (psiFile instanceof XmlFile) {
                    return AndroidUtils.loadDomElementWithReadPermission(project, (XmlFile)psiFile, aClass);
                }
                return null;
            }
        }));
    }

    public static <T extends DomElement> T loadDomElementWithReadPermission(Project project, XmlFile xmlFile, Class<T> aClass) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        DomManager domManager = DomManager.getDomManager((Project)project);
        DomFileElement element = domManager.getFileElement(xmlFile, aClass);
        if (element == null) {
            return null;
        }
        return (T)element.getRootElement();
    }

    public static VirtualFile findSourceRoot(Module module, VirtualFile file) {
        HashSet sourceRoots = new HashSet();
        Collections.addAll(sourceRoots, ModuleRootManager.getInstance((Module)module).getSourceRoots());
        while (file != null) {
            if (sourceRoots.contains(file)) {
                return file;
            }
            file = file.getParent();
        }
        return null;
    }

    public static String computePackageName(Module module, VirtualFile file) {
        HashSet sourceRoots = new HashSet();
        Collections.addAll(sourceRoots, ModuleRootManager.getInstance((Module)module).getSourceRoots());
        VirtualFile projectDir = module.getProject().getBaseDir();
        ArrayList<String> packages = new ArrayList<String>();
        for (file = file.getParent(); file != null && !Comparing.equal((Object)projectDir, (Object)file) && !sourceRoots.contains(file); file = file.getParent()) {
            packages.add(file.getName());
        }
        if (file != null && sourceRoots.contains(file)) {
            StringBuilder packageName = new StringBuilder();
            for (int i = packages.size() - 1; i >= 0; --i) {
                packageName.append((String)packages.get(i));
                if (i <= 0) continue;
                packageName.append('.');
            }
            return packageName.toString();
        }
        return null;
    }

    public static void addRunConfiguration(final AndroidFacet facet, final String activityClass, boolean ask, final TargetSelectionMode targetSelectionMode, final String preferredAvdName) {
        final Module module = facet.getModule();
        final Project project = module.getProject();
        final Runnable r = new Runnable(){

            @Override
            public void run() {
                RunManager runManager = RunManager.getInstance((Project)project);
                RunnerAndConfigurationSettings settings = runManager.createRunConfiguration(module.getName(), AndroidRunConfigurationType.getInstance().getFactory());
                AndroidRunConfiguration configuration = (AndroidRunConfiguration)settings.getConfiguration();
                configuration.setModule(module);
                if (activityClass != null) {
                    configuration.MODE = "specific_activity";
                    configuration.ACTIVITY_CLASS = activityClass;
                } else {
                    configuration.MODE = AndroidRunConfiguration.isWatchFaceApp(facet) ? "do_nothing" : "default_activity";
                }
                if (targetSelectionMode != null) {
                    configuration.setTargetSelectionMode(targetSelectionMode);
                }
                if (preferredAvdName != null) {
                    configuration.PREFERRED_AVD = preferredAvdName;
                }
                runManager.addConfiguration(settings, false);
                runManager.setSelectedConfiguration(settings);
            }
        };
        if (!ask) {
            r.run();
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    String moduleName = facet.getModule().getName();
                    int result = Messages.showYesNoDialog((Project)project, (String)AndroidBundle.message("create.run.configuration.question", moduleName), (String)AndroidBundle.message("create.run.configuration.title", new Object[0]), (Icon)Messages.getQuestionIcon());
                    if (result == 0) {
                        r.run();
                    }
                }
            });
        }
    }

    public static boolean isAbstract(PsiClass c) {
        return c.isInterface() || c.hasModifierProperty("abstract");
    }

    public static void executeCommandOnDevice(IDevice device, String command, AndroidOutputReceiver receiver, boolean infinite) throws IOException, TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException {
        long timeout = infinite ? 0L : 3000000L;
        for (int attempt = 0; attempt < 5; ++attempt) {
            boolean retry;
            device.executeShellCommand(command, (IShellOutputReceiver)receiver, timeout, TimeUnit.MILLISECONDS);
            if (receiver.isCancelled()) break;
            boolean bl = retry = infinite || receiver.isTryAgain();
            if (!retry) break;
            receiver.invalidate();
        }
    }

    public static Module getAndroidModule(ConfigurationContext context) {
        Module module = context.getModule();
        if (module == null || AndroidFacet.getInstance(module) == null) {
            return null;
        }
        return module;
    }

    public static VirtualFile createChildDirectoryIfNotExist(Project project, VirtualFile parent, String name) throws IOException {
        VirtualFile child = parent.findChild(name);
        return child == null ? parent.createChildDirectory((Object)project, name) : child;
    }

    public static PsiFile getContainingFile(PsiElement element) {
        return element instanceof PsiFile ? (PsiFile)element : element.getContainingFile();
    }

    public static void navigateTo(PsiElement[] targets, RelativePoint pointToShowPopup) {
        if (targets.length == 0) {
            JComponent renderer = HintUtil.createErrorLabel((String)"Empty text");
            JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder(renderer, renderer).createPopup();
            if (pointToShowPopup != null) {
                popup.show(pointToShowPopup);
            }
            return;
        }
        if (targets.length == 1 || pointToShowPopup == null) {
            PsiNavigateUtil.navigate((PsiElement)targets[0]);
        } else {
            DefaultPsiElementCellRenderer renderer = new DefaultPsiElementCellRenderer(){

                public String getElementText(PsiElement element) {
                    PsiFile file = AndroidUtils.getContainingFile(element);
                    return file != null ? file.getName() : super.getElementText(element);
                }

                public String getContainerText(PsiElement element, String name) {
                    PsiFile file = AndroidUtils.getContainingFile(element);
                    PsiDirectory dir = file != null ? file.getContainingDirectory() : null;
                    return dir == null ? "" : '(' + dir.getName() + ')';
                }
            };
            JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])targets, (PsiElementListCellRenderer)renderer, null);
            popup.show(pointToShowPopup);
        }
    }

    public static ExecutionStatus executeCommand(GeneralCommandLine commandLine, final OutputProcessor processor, WaitingStrategies.Strategy strategy) throws ExecutionException {
        int exitCode;
        LOG.info(commandLine.getCommandLineString());
        OSProcessHandler handler = new OSProcessHandler(commandLine.createProcess(), "");
        ProcessAdapter listener = new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (processor != null) {
                    String message = event.getText();
                    processor.onTextAvailable(message);
                }
            }
        };
        if (!(strategy instanceof WaitingStrategies.DoNotWait)) {
            handler.addProcessListener((ProcessListener)listener);
        }
        handler.startNotify();
        try {
            if (!(strategy instanceof WaitingStrategies.WaitForever)) {
                if (strategy instanceof WaitingStrategies.WaitForTime) {
                    handler.waitFor((long)((WaitingStrategies.WaitForTime)strategy).getTimeMs());
                }
            } else {
                handler.waitFor();
            }
        }
        catch (ProcessCanceledException e) {
            return ExecutionStatus.ERROR;
        }
        if (!handler.isProcessTerminated()) {
            return ExecutionStatus.TIMEOUT;
        }
        if (!(strategy instanceof WaitingStrategies.DoNotWait)) {
            handler.removeProcessListener((ProcessListener)listener);
        }
        return (exitCode = handler.getProcess().exitValue()) == 0 ? ExecutionStatus.SUCCESS : ExecutionStatus.ERROR;
    }

    public static String getSimpleNameByRelativePath(String relativePath) {
        int index = (relativePath = FileUtil.toSystemIndependentName((String)relativePath)).lastIndexOf(47);
        if (index < 0) {
            return relativePath;
        }
        return relativePath.substring(index + 1);
    }

    public static void printMessageToConsole(Project project, String s, ConsoleViewContentType contentType) {
        ConsoleView consoleView = (ConsoleView)project.getUserData(CONSOLE_VIEW_KEY);
        if (consoleView != null) {
            consoleView.print(s + '\n', contentType);
        }
    }

    public static void activateConsoleToolWindow(Project project, final Runnable runAfterActivation) {
        String toolWindowId;
        final ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
        ToolWindow toolWindow = manager.getToolWindow(toolWindowId = AndroidBundle.message("android.console.tool.window.title", new Object[0]));
        if (toolWindow != null) {
            runAfterActivation.run();
            return;
        }
        toolWindow = manager.registerToolWindow(toolWindowId, true, ToolWindowAnchor.BOTTOM);
        ConsoleViewImpl console = new ConsoleViewImpl(project, false);
        project.putUserData(CONSOLE_VIEW_KEY, (Object)console);
        toolWindow.getContentManager().addContent((Content)new ContentImpl(console.getComponent(), "", false));
        final ToolWindowManagerListener listener = new ToolWindowManagerListener(){

            public void toolWindowRegistered(String id) {
            }

            public void stateChanged() {
                ToolWindow window = manager.getToolWindow(toolWindowId);
                if (window != null && !window.isVisible()) {
                    ((ToolWindowManagerEx)manager).removeToolWindowManagerListener((ToolWindowManagerListener)this);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            manager.unregisterToolWindow(toolWindowId);
                        }
                    });
                }
            }
        };
        toolWindow.show(new Runnable(){

            @Override
            public void run() {
                runAfterActivation.run();
                ((ToolWindowManagerEx)manager).addToolWindowManagerListener(listener);
            }
        });
    }

    public static AndroidFacet addAndroidFacetInWriteAction(final Module module, final VirtualFile contentRoot, final boolean library) {
        return (AndroidFacet)((Object)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<AndroidFacet>(){

            public AndroidFacet compute() {
                return AndroidUtils.addAndroidFacet(module, contentRoot, library);
            }
        }));
    }

    public static AndroidFacet addAndroidFacet(Module module, VirtualFile contentRoot, boolean library) {
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        ModifiableFacetModel model = facetManager.createModifiableModel();
        AndroidFacet facet = (AndroidFacet)model.getFacetByType(AndroidFacet.ID);
        if (facet == null) {
            facet = (AndroidFacet)facetManager.createFacet((FacetType)AndroidFacet.getFacetType(), "Android", null);
            AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet.getConfiguration();
            configuration.init(module, contentRoot);
            if (library) {
                configuration.getState().LIBRARY_PROJECT = true;
            }
            model.addFacet((Facet)facet);
        }
        model.commit();
        return facet;
    }

    public static VirtualFile findFileByAbsoluteOrRelativePath(VirtualFile baseDir, String path) {
        VirtualFile libDir = LocalFileSystem.getInstance().findFileByPath(path);
        if (libDir != null) {
            return libDir;
        }
        if (baseDir != null) {
            return LocalFileSystem.getInstance().findFileByPath(baseDir.getPath() + '/' + path);
        }
        return null;
    }

    public static int getIntAttrValue(final XmlTag tag, final String attrName) {
        String value = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return tag.getAttributeValue(attrName, "http://schemas.android.com/apk/res/android");
            }
        });
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static void collectFiles(VirtualFile root, Set<VirtualFile> visited, Set<VirtualFile> result) {
        if (!visited.add(root)) {
            return;
        }
        if (root.isDirectory()) {
            for (VirtualFile child : root.getChildren()) {
                AndroidUtils.collectFiles(child, visited, result);
            }
        } else {
            result.add(root);
        }
    }

    public static TargetSelectionMode getDefaultTargetSelectionMode(Module module, ConfigurationType type, @NonNls ConfigurationType alternativeType) {
        RunManager runManager = RunManager.getInstance((Project)module.getProject());
        List configurations = runManager.getConfigurationsList(type);
        TargetSelectionMode alternative = null;
        if (configurations.size() > 0) {
            for (RunConfiguration configuration : configurations) {
                if (!(configuration instanceof AndroidRunConfigurationBase)) continue;
                AndroidRunConfigurationBase runConfig = (AndroidRunConfigurationBase)configuration;
                TargetSelectionMode targetMode = runConfig.getTargetSelectionMode();
                if (runConfig.getConfigurationModule() == module) {
                    return targetMode;
                }
                alternative = targetMode;
            }
        }
        if (alternative != null) {
            return alternative;
        }
        configurations = runManager.getConfigurationsList(alternativeType);
        if (configurations.size() > 0) {
            for (RunConfiguration configuration : configurations) {
                if (!(configuration instanceof AndroidRunConfigurationBase)) continue;
                return ((AndroidRunConfigurationBase)configuration).getTargetSelectionMode();
            }
        }
        return null;
    }

    public static boolean equal(String s1, String s2, boolean distinguishDelimeters) {
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        int n = s1.length();
        for (int i = 0; i < n; ++i) {
            char c1 = s1.charAt(i);
            char c2 = s2.charAt(i);
            if (!distinguishDelimeters && (!Character.isLetterOrDigit(c1) || !Character.isLetterOrDigit(c2)) || c1 == c2) continue;
            return false;
        }
        return true;
    }

    public static List<AndroidFacet> getApplicationFacets(Project project) {
        ArrayList<AndroidFacet> result = new ArrayList<AndroidFacet>();
        for (AndroidFacet facet : ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID)) {
            if (facet.isLibraryProject()) continue;
            result.add(facet);
        }
        return result;
    }

    public static List<AndroidFacet> getAndroidLibraryDependencies(Module module) {
        ArrayList<AndroidFacet> depFacets = new ArrayList<AndroidFacet>();
        for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            AndroidFacet depFacet;
            Module depModule;
            ModuleOrderEntry moduleOrderEntry;
            if (!(orderEntry instanceof ModuleOrderEntry) || (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getScope() != DependencyScope.COMPILE || (depModule = moduleOrderEntry.getModule()) == null || (depFacet = AndroidFacet.getInstance(depModule)) == null || !depFacet.isLibraryProject()) continue;
            depFacets.add(depFacet);
        }
        return depFacets;
    }

    public static List<AndroidFacet> getAllAndroidDependencies(Module module, boolean androidLibrariesOnly) {
        return AndroidDependenciesCache.getInstance(module).getAllAndroidDependencies(androidLibrariesOnly);
    }

    public static Set<String> getDepLibsPackages(Module module) {
        HashSet result = new HashSet();
        HashSet visited = new HashSet();
        if (visited.add((Object)module)) {
            for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(module, true)) {
                String aPackage;
                Manifest manifest = depFacet.getManifest();
                if (manifest == null || (aPackage = (String)manifest.getPackage().getValue()) == null) continue;
                result.add(aPackage);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkNewPassword(JPasswordField passwordField, JPasswordField confirmedPasswordField) throws CommitStepException {
        char[] password = passwordField.getPassword();
        char[] confirmedPassword = confirmedPasswordField.getPassword();
        try {
            AndroidUtils.checkPassword(password);
            if (password.length < 6) {
                throw new CommitStepException(AndroidBundle.message("android.export.package.incorrect.password.length", new Object[0]));
            }
            if (!Arrays.equals(password, confirmedPassword)) {
                throw new CommitStepException(AndroidBundle.message("android.export.package.passwords.not.match.error", new Object[0]));
            }
        }
        finally {
            Arrays.fill(password, '\u0000');
            Arrays.fill(confirmedPassword, '\u0000');
        }
    }

    public static void checkPassword(char[] password) throws CommitStepException {
        if (password.length == 0) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.password.error", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkPassword(JPasswordField passwordField) throws CommitStepException {
        char[] password = passwordField.getPassword();
        try {
            AndroidUtils.checkPassword(password);
        }
        finally {
            Arrays.fill(password, '\u0000');
        }
    }

    public static <T> List<T> toList(Enumeration<T> enumeration) {
        return ContainerUtil.toList(enumeration);
    }

    public static void reportError(Project project, String message) {
        AndroidUtils.reportError(project, message, CommonBundle.getErrorTitle());
    }

    public static void reportError(Project project, String message, String title) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IncorrectOperationException(message);
        }
        Messages.showErrorDialog((Project)project, (String)message, (String)title);
    }

    public static void showStackStace(Project project, Throwable[] throwables) {
        final StringBuilder messageBuilder = new StringBuilder();
        for (Throwable t : throwables) {
            if (messageBuilder.length() > 0) {
                messageBuilder.append("\n\n");
            }
            messageBuilder.append(AndroidCommonUtils.getStackTrace((Throwable)t));
        }
        DialogWrapper wrapper = new DialogWrapper(project, false){
            {
                super(x0, x1);
                this.init();
            }

            protected JComponent createCenterPanel() {
                JPanel panel = new JPanel(new BorderLayout());
                JTextArea textArea = new JTextArea(messageBuilder.toString());
                textArea.setEditable(false);
                textArea.setRows(40);
                textArea.setColumns(70);
                panel.add(ScrollPaneFactory.createScrollPane((Component)textArea));
                return panel;
            }
        };
        wrapper.setTitle("Stack trace");
        wrapper.show();
    }

    public static boolean isValidAndroidPackageName(String name) {
        return AndroidUtils.validateAndroidPackageName(name) == null;
    }

    public static boolean isValidJavaPackageName(String name) {
        int index = 0;
        while (true) {
            int index1;
            if ((index1 = name.indexOf(46, index)) < 0) {
                index1 = name.length();
            }
            if (!AndroidUtils.isIdentifier(name.substring(index, index1))) {
                return false;
            }
            if (index1 == name.length()) {
                return true;
            }
            index = index1 + 1;
        }
    }

    public static String validateAndroidPackageName(String name) {
        if (name.isEmpty()) {
            return "Package name is missing";
        }
        String packageManagerCheck = AndroidUtils.validateName(name, true);
        if (packageManagerCheck != null) {
            return packageManagerCheck;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Lexer lexer = JavaParserDefinition.createLexer((LanguageLevel)LanguageLevel.JDK_1_5);
        int index = 0;
        while (true) {
            int index1;
            if ((index1 = name.indexOf(46, index)) < 0) {
                index1 = name.length();
            }
            String segment = name.substring(index, index1);
            lexer.start((CharSequence)segment);
            if (lexer.getTokenType() != JavaTokenType.IDENTIFIER) {
                if (lexer.getTokenType() instanceof IKeywordElementType) {
                    return "Package names cannot contain Java keywords like '" + segment + "'";
                }
                if (segment.isEmpty()) {
                    return "Package segments must be of non-zero length";
                }
                return segment + " is not a valid identifier";
            }
            if (index1 == name.length()) break;
            index = index1 + 1;
        }
        return null;
    }

    private static String validateName(String name, boolean requiresSeparator) {
        int N = name.length();
        boolean hasSep = false;
        boolean front = true;
        for (int i = 0; i < N; ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                front = false;
                continue;
            }
            if (c >= '0' && c <= '9' || c == '_') {
                if (!front) continue;
                if (c == '_') {
                    return "The character '_' cannot be the first character in a package segment";
                }
                return "A digit cannot be the first character in a package segment";
            }
            if (c == '.') {
                hasSep = true;
                front = true;
                continue;
            }
            return "The character '" + c + "' is not allowed in Android application package names";
        }
        return hasSep || !requiresSeparator ? null : "The package must have at least one '.' separator";
    }

    public static boolean isIdentifier(String candidate) {
        return StringUtil.isJavaIdentifier((String)candidate) && !JavaLexer.isKeyword((String)candidate, (LanguageLevel)LanguageLevel.JDK_1_5);
    }

    public static void reportImportErrorToEventLog(String message, String modName, Project project) {
        AndroidUtils.reportImportErrorToEventLog(message, modName, project, null);
    }

    public static void reportImportErrorToEventLog(String message, String modName, Project project, NotificationListener listener) {
        Notifications.Bus.notify((Notification)new Notification(AndroidBundle.message("android.facet.importing.notification.group", new Object[0]), AndroidBundle.message("android.facet.importing.title", modName), message, NotificationType.ERROR, listener), (Project)project);
        LOG.debug(message);
    }

    public static boolean isPackagePrefix(String prefix, String name) {
        return name.equals(prefix) || name.startsWith(prefix + ".");
    }

    public static Set<Module> getSetWithBackwardDependencies(Collection<Module> modules) {
        HashSet set = new HashSet();
        for (Module module : modules) {
            AndroidUtils.collectModules(module, (Set<Module>)set, ModuleManager.getInstance((Project)module.getProject()).getModules());
        }
        return set;
    }

    private static void collectModules(Module module, Set<Module> result, Module[] allModules) {
        if (!result.add(module)) {
            return;
        }
        for (Module otherModule : allModules) {
            if (!ModuleRootManager.getInstance((Module)otherModule).isDependsOn(module)) continue;
            AndroidUtils.collectModules(otherModule, result, allModules);
        }
    }

    public static List<String> urlsToOsPaths(List<String> urls, String sdkHomeCanonicalPath) {
        if (urls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(urls.size());
        for (String url : urls) {
            if (sdkHomeCanonicalPath != null) {
                url = StringUtil.replace((String)url, (String)"%MODULE_SDK_HOME%", (String)sdkHomeCanonicalPath);
            }
            result.add(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url)));
        }
        return result;
    }

    public static String getAndroidSystemDirectoryOsPath() {
        return PathManager.getSystemPath() + File.separator + "android";
    }

    public static boolean isAndroidComponent(PsiClass c) {
        Project project = c.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        for (String componentClassName : ANDROID_COMPONENT_CLASSES) {
            PsiClass componentClass = facade.findClass(componentClassName, ProjectScope.getAllScope((Project)project));
            if (componentClass == null || !c.isInheritor(componentClass, true)) continue;
            return true;
        }
        return false;
    }
}

