/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

public class WaitingStrategies {

    public static class WaitForever
    extends Strategy {
        private static final WaitForever INSTANCE = new WaitForever();

        private WaitForever() {
        }

        public static WaitForever getInstance() {
            return INSTANCE;
        }
    }

    public static class WaitForTime
    extends Strategy {
        private final int myTimeMs;

        private WaitForTime(int timeMs) {
            assert (timeMs > 0);
            this.myTimeMs = timeMs;
        }

        public static WaitForTime getInstance(int timeMs) {
            return new WaitForTime(timeMs);
        }

        public int getTimeMs() {
            return this.myTimeMs;
        }
    }

    public static class DoNotWait
    extends Strategy {
        private static final DoNotWait INSTANCE = new DoNotWait();

        private DoNotWait() {
        }

        public static DoNotWait getInstance() {
            return INSTANCE;
        }
    }

    public static abstract class Strategy {
        private Strategy() {
        }
    }
}

