/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.InputStream;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.bootstrap.DaemonGreeter;
import org.gradle.launcher.daemon.client.DaemonClientServicesSupport;
import org.gradle.launcher.daemon.client.DaemonStartListener;
import org.gradle.launcher.daemon.client.DaemonStarter;
import org.gradle.launcher.daemon.client.DefaultDaemonStarter;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.context.DaemonContextBuilder;
import org.gradle.launcher.daemon.registry.DaemonDir;
import org.gradle.launcher.daemon.registry.DaemonRegistryServices;

public class DaemonClientServices
extends DaemonClientServicesSupport {
    private final DaemonParameters daemonParameters;

    public DaemonClientServices(ServiceRegistry parent, DaemonParameters daemonParameters, InputStream buildStandardInput) {
        super(parent, buildStandardInput);
        this.daemonParameters = daemonParameters;
        this.addProvider(new DaemonRegistryServices(daemonParameters.getBaseDir()));
    }

    DaemonStarter createDaemonStarter(DaemonDir daemonDir, DaemonParameters daemonParameters, ListenerManager listenerManager, DaemonGreeter daemonGreeter) {
        return new DefaultDaemonStarter(daemonDir, daemonParameters, daemonGreeter, (DaemonStartListener)listenerManager.getBroadcaster(DaemonStartListener.class));
    }

    DaemonGreeter createDaemonGreeter(DocumentationRegistry documentationRegistry) {
        return new DaemonGreeter(documentationRegistry);
    }

    protected void configureDaemonContextBuilder(DaemonContextBuilder builder) {
        builder.setDaemonRegistryDir(this.get(DaemonDir.class).getBaseDir());
        builder.useDaemonParameters(this.daemonParameters);
    }

    DaemonParameters createDaemonParameters() {
        return this.daemonParameters;
    }
}

