/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.internal.classpath.DefaultModuleRegistry;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.launcher.daemon.DaemonExecHandleBuilder;
import org.gradle.launcher.daemon.bootstrap.DaemonGreeter;
import org.gradle.launcher.daemon.bootstrap.DaemonOutputConsumer;
import org.gradle.launcher.daemon.bootstrap.GradleDaemon;
import org.gradle.launcher.daemon.client.DaemonStartListener;
import org.gradle.launcher.daemon.client.DaemonStarter;
import org.gradle.launcher.daemon.client.JvmVersionValidator;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.diagnostics.DaemonStartupInfo;
import org.gradle.launcher.daemon.registry.DaemonDir;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecHandle;
import org.gradle.util.Clock;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GFileUtils;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDaemonStarter
implements DaemonStarter {
    private static final Logger LOGGER = Logging.getLogger(DefaultDaemonStarter.class);
    private final DaemonDir daemonDir;
    private final DaemonParameters daemonParameters;
    private final DaemonGreeter daemonGreeter;
    private final DaemonStartListener listener;

    public DefaultDaemonStarter(DaemonDir daemonDir, DaemonParameters daemonParameters, DaemonGreeter daemonGreeter, DaemonStartListener listener) {
        this.daemonDir = daemonDir;
        this.daemonParameters = daemonParameters;
        this.daemonGreeter = daemonGreeter;
        this.listener = listener;
    }

    @Override
    public DaemonStartupInfo startDaemon() {
        DefaultModuleRegistry registry = new DefaultModuleRegistry();
        LinkedHashSet<File> bootstrapClasspath = new LinkedHashSet<File>();
        bootstrapClasspath.addAll(registry.getModule("gradle-launcher").getImplementationClasspath().getAsFiles());
        if (registry.getGradleHome() == null) {
            bootstrapClasspath.addAll(registry.getFullClasspath());
        }
        if (bootstrapClasspath.isEmpty()) {
            throw new IllegalStateException("Unable to construct a bootstrap classpath when starting the daemon");
        }
        new JvmVersionValidator().validate(this.daemonParameters);
        ArrayList<String> daemonArgs = new ArrayList<String>();
        daemonArgs.add(this.daemonParameters.getEffectiveJavaExecutable());
        List<String> daemonOpts = this.daemonParameters.getEffectiveJvmArgs();
        LOGGER.debug("Using daemon opts: {}", daemonOpts);
        daemonArgs.addAll(daemonOpts);
        daemonArgs.add("-cp");
        daemonArgs.add(CollectionUtils.join(File.pathSeparator, bootstrapClasspath));
        daemonArgs.add(GradleDaemon.class.getName());
        daemonArgs.add(GradleVersion.current().getVersion());
        daemonArgs.add(this.daemonParameters.getGradleUserHomeDir().getAbsolutePath());
        daemonArgs.add(this.daemonDir.getBaseDir().getAbsolutePath());
        daemonArgs.add(String.valueOf(this.daemonParameters.getIdleTimeout()));
        daemonArgs.add(this.daemonParameters.getUid());
        daemonArgs.addAll(daemonOpts);
        DaemonStartupInfo daemonInfo = this.startProcess(daemonArgs, this.daemonDir.getVersionedDir());
        this.listener.daemonStarted(daemonInfo);
        return daemonInfo;
    }

    private DaemonStartupInfo startProcess(List<String> args, File workingDir) {
        LOGGER.info("Starting daemon process: workingDir = {}, daemonArgs: {}", workingDir, args);
        Clock clock = new Clock();
        try {
            GFileUtils.mkdirs(workingDir);
            DaemonOutputConsumer outputConsumer = new DaemonOutputConsumer();
            ExecHandle handle = new DaemonExecHandleBuilder().build(args, workingDir, outputConsumer);
            handle.start();
            LOGGER.debug("Gradle daemon process is starting. Waiting for the daemon to detach...");
            ExecResult result = handle.waitForFinish();
            LOGGER.debug("Gradle daemon process is now detached.");
            DaemonStartupInfo daemonStartupInfo = this.daemonGreeter.parseDaemonOutput(outputConsumer.getProcessOutput(), result);
            return daemonStartupInfo;
        }
        catch (GradleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GradleException("Could not start Gradle daemon.", e);
        }
        finally {
            LOGGER.info("An attempt to start the daemon took {}.", clock.getTime());
        }
    }
}

