/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.File;
import java.util.UUID;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.GlobalScopeServices;
import org.gradle.launcher.daemon.client.DaemonClientServicesSupport;
import org.gradle.launcher.daemon.client.DaemonStarter;
import org.gradle.launcher.daemon.client.EmbeddedDaemonStarter;
import org.gradle.launcher.daemon.client.StubDaemonHealthServices;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.context.DaemonContextBuilder;
import org.gradle.launcher.daemon.registry.DaemonDir;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.registry.EmbeddedDaemonRegistry;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonServerConnector;
import org.gradle.launcher.daemon.server.DaemonTcpServerConnector;
import org.gradle.launcher.daemon.server.exec.DaemonCommandExecuter;
import org.gradle.launcher.daemon.server.exec.DefaultDaemonCommandExecuter;
import org.gradle.launcher.daemon.server.exec.StopHandlingCommandExecuter;
import org.gradle.launcher.exec.InProcessBuildActionExecuter;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.LoggingServiceRegistry;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.messaging.remote.internal.MessagingServices;
import org.gradle.messaging.remote.internal.inet.InetAddressFactory;

public class EmbeddedDaemonClientServices
extends DaemonClientServicesSupport {
    public EmbeddedDaemonClientServices() {
        this((ServiceRegistry)LoggingServiceRegistry.newCommandLineProcessLogging());
    }

    protected DaemonCommandExecuter createDaemonCommandExecuter() {
        LoggingManagerInternal mgr = this.newInstance(LoggingManagerInternal.class);
        return new StopHandlingCommandExecuter(new DefaultDaemonCommandExecuter(this.get(InProcessBuildActionExecuter.class), this.get(ProcessEnvironment.class), mgr, new File("dummy"), new StubDaemonHealthServices()));
    }

    public EmbeddedDaemonClientServices(ServiceRegistry loggingServices) {
        super(ServiceRegistryBuilder.builder().parent(loggingServices).parent((ServiceRegistry)NativeServices.getInstance()).build(), System.in);
        this.addProvider(new GlobalScopeServices(true));
        this.add(EmbeddedDaemonFactory.class, new EmbeddedDaemonFactory());
    }

    protected DaemonRegistry createDaemonRegistry() {
        return new EmbeddedDaemonRegistry();
    }

    protected OutputEventListener createOutputEventListener() {
        return new OutputEventListener(){

            public void onOutput(OutputEvent event) {
            }
        };
    }

    protected void configureDaemonContextBuilder(DaemonContextBuilder builder) {
        builder.setUid(UUID.randomUUID().toString());
        builder.setDaemonRegistryDir(new DaemonDir(new DaemonParameters(new BuildLayoutParameters()).getBaseDir()).getRegistry());
    }

    protected DaemonServerConnector createDaemonServerConnector() {
        return new DaemonTcpServerConnector(this.get(ExecutorFactory.class), (InetAddressFactory)this.get(MessagingServices.class).get(InetAddressFactory.class));
    }

    protected DaemonStarter createDaemonStarter() {
        return new EmbeddedDaemonStarter(this.getFactory(Daemon.class));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EmbeddedDaemonFactory
    implements Factory<Daemon> {
        private EmbeddedDaemonFactory() {
        }

        @Override
        public Daemon create() {
            return new Daemon(EmbeddedDaemonClientServices.this.get(DaemonServerConnector.class), EmbeddedDaemonClientServices.this.get(DaemonRegistry.class), EmbeddedDaemonClientServices.this.get(DaemonContext.class), "password", EmbeddedDaemonClientServices.this.get(DaemonCommandExecuter.class), EmbeddedDaemonClientServices.this.get(ExecutorFactory.class));
        }
    }
}

