/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.api;

import java.util.LinkedList;
import java.util.List;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.protocol.BuildAndStop;
import org.gradle.launcher.daemon.protocol.Command;
import org.gradle.launcher.daemon.server.api.DaemonCommandAction;
import org.gradle.launcher.daemon.server.api.DaemonConnection;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonCommandExecution {
    private final DaemonConnection connection;
    private final Command command;
    private final DaemonContext daemonContext;
    private final DaemonStateControl daemonStateControl;
    private final List<DaemonCommandAction> actions;
    private Throwable exception;
    private Object result;

    public DaemonCommandExecution(DaemonConnection connection, Command command, DaemonContext daemonContext, DaemonStateControl daemonStateControl, List<DaemonCommandAction> actions) {
        this.connection = connection;
        this.command = command;
        this.daemonContext = daemonContext;
        this.daemonStateControl = daemonStateControl;
        this.actions = new LinkedList<DaemonCommandAction>(actions);
    }

    public DaemonConnection getConnection() {
        return this.connection;
    }

    public Command getCommand() {
        return this.command;
    }

    public DaemonContext getDaemonContext() {
        return this.daemonContext;
    }

    public DaemonStateControl getDaemonStateControl() {
        return this.daemonStateControl;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Object getResult() {
        return this.result;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean proceed() {
        if (this.actions.isEmpty()) {
            return false;
        }
        this.actions.remove(0).execute(this);
        return true;
    }

    public boolean isSingleUseDaemon() {
        return this.getCommand() instanceof BuildAndStop;
    }

    public String toString() {
        return String.format("DaemonCommandExecution[command = %s, connection = %s]", this.command, this.connection);
    }
}

