/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.diagnostics.DaemonDiagnostics;
import org.gradle.launcher.daemon.protocol.Command;
import org.gradle.launcher.daemon.server.api.DaemonCommandAction;
import org.gradle.launcher.daemon.server.api.DaemonCommandExecution;
import org.gradle.launcher.daemon.server.api.DaemonConnection;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;
import org.gradle.launcher.daemon.server.exec.DaemonCommandExecuter;
import org.gradle.launcher.daemon.server.exec.EstablishBuildEnvironment;
import org.gradle.launcher.daemon.server.exec.ExecuteBuild;
import org.gradle.launcher.daemon.server.exec.ForwardClientInput;
import org.gradle.launcher.daemon.server.exec.HandleCancel;
import org.gradle.launcher.daemon.server.exec.LogToClient;
import org.gradle.launcher.daemon.server.exec.RequestStopIfSingleUsedDaemon;
import org.gradle.launcher.daemon.server.exec.ResetDeprecationLogger;
import org.gradle.launcher.daemon.server.exec.ReturnResult;
import org.gradle.launcher.daemon.server.exec.StartBuildOrRespondWithBusy;
import org.gradle.launcher.daemon.server.exec.WatchForDisconnection;
import org.gradle.launcher.daemon.server.health.DaemonHealthServices;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.internal.LoggingOutputInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDaemonCommandExecuter
implements DaemonCommandExecuter {
    private final LoggingOutputInternal loggingOutput;
    private final BuildActionExecuter<BuildActionParameters> actionExecuter;
    private final DaemonHealthServices healthServices;
    private final ProcessEnvironment processEnvironment;
    private final File daemonLog;

    public DefaultDaemonCommandExecuter(BuildActionExecuter<BuildActionParameters> actionExecuter, ProcessEnvironment processEnvironment, LoggingManagerInternal loggingOutput, File daemonLog, DaemonHealthServices healthServices) {
        this.processEnvironment = processEnvironment;
        this.daemonLog = daemonLog;
        this.loggingOutput = loggingOutput;
        this.actionExecuter = actionExecuter;
        this.healthServices = healthServices;
    }

    @Override
    public void executeCommand(DaemonConnection connection, Command command, DaemonContext daemonContext, DaemonStateControl daemonStateControl) {
        new DaemonCommandExecution(connection, command, daemonContext, daemonStateControl, this.createActions(daemonContext)).proceed();
    }

    protected List<DaemonCommandAction> createActions(DaemonContext daemonContext) {
        DaemonDiagnostics daemonDiagnostics = new DaemonDiagnostics(this.daemonLog, daemonContext.getPid());
        return ImmutableList.of((Object)new HandleCancel(), (Object)new ReturnResult(), (Object)new StartBuildOrRespondWithBusy(daemonDiagnostics), (Object)this.healthServices.getGCHintAction(), (Object)new EstablishBuildEnvironment(this.processEnvironment), (Object)new LogToClient(this.loggingOutput, daemonDiagnostics), (Object)this.healthServices.getHealthTrackerAction(), (Object)new ForwardClientInput(), (Object)new RequestStopIfSingleUsedDaemon(), (Object)new ResetDeprecationLogger(), (Object)new WatchForDisconnection(), (Object)new ExecuteBuild(this.actionExecuter), (Object[])new DaemonCommandAction[0]);
    }
}

