/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.logging.LogLevel;
import org.gradle.launcher.daemon.configuration.DaemonUsage;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildActionParameters
implements BuildActionParameters,
Serializable {
    private final File currentDir;
    private final LogLevel logLevel;
    private final Map<String, String> systemProperties;
    private final Map<String, String> envVariables;
    private final DaemonUsage daemonUsage;

    public DefaultBuildActionParameters(Map<?, ?> systemProperties, Map<String, String> envVariables, File currentDir, LogLevel logLevel, DaemonUsage daemonUsage) {
        this.currentDir = currentDir;
        this.logLevel = logLevel;
        assert (systemProperties != null);
        assert (envVariables != null);
        this.systemProperties = new HashMap<String, String>();
        GUtil.addToMap(this.systemProperties, systemProperties);
        this.envVariables = new HashMap<String, String>(envVariables);
        this.daemonUsage = daemonUsage;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public Map<String, String> getEnvVariables() {
        return this.envVariables;
    }

    @Override
    public File getCurrentDir() {
        return this.currentDir;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public String toString() {
        return "DefaultBuildActionParameters{, currentDir=" + this.currentDir + ", systemProperties size=" + this.systemProperties.size() + ", envVariables size=" + this.envVariables.size() + '}';
    }

    @Override
    public DaemonUsage getDaemonUsage() {
        return this.daemonUsage;
    }
}

