/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import org.gradle.BuildResult;
import org.gradle.api.internal.GradleInternal;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.DefaultGradleLauncher;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.ReportedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InProcessBuildActionExecuter
implements BuildActionExecuter<BuildActionParameters> {
    private final GradleLauncherFactory gradleLauncherFactory;
    private final BuildActionRunner buildActionRunner;

    public InProcessBuildActionExecuter(GradleLauncherFactory gradleLauncherFactory, BuildActionRunner buildActionRunner) {
        this.gradleLauncherFactory = gradleLauncherFactory;
        this.buildActionRunner = buildActionRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(BuildAction action, BuildRequestContext buildRequestContext, BuildActionParameters actionParameters) {
        DefaultGradleLauncher gradleLauncher = (DefaultGradleLauncher)this.gradleLauncherFactory.newInstance(action.getStartParameter(), buildRequestContext);
        try {
            DefaultBuildController buildController = new DefaultBuildController(gradleLauncher);
            this.buildActionRunner.run(action, buildController);
            Object object = buildController.result;
            return object;
        }
        finally {
            gradleLauncher.stop();
        }
    }

    private static class DefaultBuildController
    implements BuildController {
        private State state = State.Created;
        private boolean hasResult;
        private Object result;
        private final DefaultGradleLauncher gradleLauncher;

        public DefaultBuildController(DefaultGradleLauncher gradleLauncher) {
            this.gradleLauncher = gradleLauncher;
        }

        public DefaultGradleLauncher getLauncher() {
            if (this.state == State.Completed) {
                throw new IllegalStateException("Cannot use launcher after build has completed.");
            }
            return this.gradleLauncher;
        }

        public boolean hasResult() {
            return this.hasResult;
        }

        public Object getResult() {
            if (!this.hasResult) {
                throw new IllegalStateException("No result has been provided for this build action.");
            }
            return this.result;
        }

        public void setResult(Object result) {
            this.hasResult = true;
            this.result = result;
        }

        public GradleInternal getGradle() {
            return this.getLauncher().getGradle();
        }

        public GradleInternal run() {
            return this.check(this.getLauncher().run());
        }

        public GradleInternal configure() {
            return this.check(this.getLauncher().getBuildAnalysis());
        }

        private GradleInternal check(BuildResult buildResult) {
            this.state = State.Completed;
            if (buildResult.getFailure() != null) {
                throw new ReportedException(buildResult.getFailure());
            }
            return (GradleInternal)buildResult.getGradle();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum State {
            Created,
            Completed;

        }
    }
}

