/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import com.google.common.collect.MapMaker;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.GradleException;
import org.gradle.internal.classloader.ClasspathUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ClasspathInferer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathInferer.class);
    private final Lock lock = new ReentrantLock();
    private final Map<Class<?>, Collection<URL>> classPathCache = new MapMaker().weakKeys().makeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getClassPathFor(Class<?> targetClass, Collection<URL> dest) {
        this.lock.lock();
        try {
            Collection<URL> classPath = this.classPathCache.get(targetClass);
            if (classPath == null) {
                HashSet visited = new HashSet();
                classPath = new LinkedHashSet<URL>();
                this.find(targetClass, visited, classPath);
                this.classPathCache.put(targetClass, classPath);
            }
            dest.addAll(classPath);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void find(Class<?> target, Collection<Class<?>> visited, Collection<URL> dest) {
        ClassLoader targetClassLoader = target.getClassLoader();
        if (targetClassLoader == null) {
            return;
        }
        if (!visited.add(target)) {
            return;
        }
        String resourceName = target.getName().replace(".", "/") + ".class";
        URL resource = targetClassLoader.getResource(resourceName);
        try {
            ClassReader reader;
            if (resource == null) {
                LOGGER.warn("Could not determine classpath for {}", target);
                return;
            }
            File classPathRoot = ClasspathUtil.getClasspathForClass(target);
            dest.add(classPathRoot.toURI().toURL());
            InputStream inputStream = resource.openStream();
            try {
                reader = new ClassReader(inputStream);
            }
            finally {
                inputStream.close();
            }
            char[] charBuffer = new char[reader.getMaxStringLength()];
            for (int i = 1; i < reader.getItemCount(); ++i) {
                Class<?> cl;
                String className;
                int itemOffset = reader.getItem(i);
                if (itemOffset <= 0 || reader.readByte(itemOffset - 1) != 7) continue;
                String classDescriptor = reader.readUTF8(itemOffset, charBuffer);
                Type type = Type.getObjectType((String)classDescriptor);
                while (type.getSort() == 9) {
                    type = type.getElementType();
                }
                if (type.getSort() != 10 || (className = type.getClassName()).equals(target.getName())) continue;
                try {
                    cl = Class.forName(className, false, targetClassLoader);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.warn("Could not determine classpath for {}", target);
                    continue;
                }
                this.find(cl, visited, dest);
            }
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not determine the class-path for %s.", target), e);
        }
    }
}

