/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.api.BuildCancelledException;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.DefaultBuildActionParameters;
import org.gradle.launcher.exec.ReportedException;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.InternalBuildCancelledException;
import org.gradle.tooling.internal.provider.connection.ProviderOperationParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonBuildActionExecuter
implements BuildActionExecuter<ProviderOperationParameters> {
    private final BuildActionExecuter<BuildActionParameters> executer;
    private final DaemonParameters daemonParameters;

    public DaemonBuildActionExecuter(BuildActionExecuter<BuildActionParameters> executer, DaemonParameters daemonParameters) {
        this.executer = executer;
        this.daemonParameters = daemonParameters;
    }

    @Override
    public Object execute(BuildAction action, BuildRequestContext buildRequestContext, ProviderOperationParameters parameters) {
        DefaultBuildActionParameters actionParameters = new DefaultBuildActionParameters(this.daemonParameters.getEffectiveSystemProperties(), System.getenv(), SystemProperties.getInstance().getCurrentDir(), parameters.getBuildLogLevel(), this.daemonParameters.getDaemonUsage());
        try {
            return this.executer.execute(action, buildRequestContext, actionParameters);
        }
        catch (ReportedException e) {
            for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
                if (!(t instanceof BuildCancelledException)) continue;
                throw new InternalBuildCancelledException(e.getCause());
            }
            throw new BuildExceptionVersion1(e.getCause());
        }
    }
}

