/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.util.List;
import org.gradle.cache.CacheRepository;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.PluginServiceRegistry;
import org.gradle.launcher.exec.ChainingBuildActionRunner;
import org.gradle.launcher.exec.InProcessBuildActionExecuter;
import org.gradle.tooling.internal.provider.ClassLoaderCache;
import org.gradle.tooling.internal.provider.DaemonSidePayloadClassLoaderFactory;
import org.gradle.tooling.internal.provider.DefaultPayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.ExecuteBuildActionRunner;
import org.gradle.tooling.internal.provider.JarCache;
import org.gradle.tooling.internal.provider.ModelClassLoaderFactory;
import org.gradle.tooling.internal.provider.PayloadClassLoaderFactory;
import org.gradle.tooling.internal.provider.PayloadSerializer;

public class LauncherServices
implements PluginServiceRegistry {
    public void registerGlobalServices(ServiceRegistration registration) {
        registration.addProvider(new ToolingGlobalScopeServices());
    }

    public void registerBuildServices(ServiceRegistration registration) {
        registration.addProvider(new ToolingBuildScopeServices());
    }

    public void registerGradleServices(ServiceRegistration registration) {
    }

    public void registerProjectServices(ServiceRegistration registration) {
    }

    static class ToolingBuildScopeServices {
        ToolingBuildScopeServices() {
        }

        PayloadClassLoaderFactory createClassLoaderFactory(ClassLoaderFactory classLoaderFactory, JarCache jarCache, CacheRepository cacheRepository) {
            return new DaemonSidePayloadClassLoaderFactory(new ModelClassLoaderFactory(classLoaderFactory), jarCache, cacheRepository);
        }

        PayloadSerializer createPayloadSerializer(ClassLoaderCache classLoaderCache, PayloadClassLoaderFactory classLoaderFactory) {
            return new PayloadSerializer(new DefaultPayloadClassLoaderRegistry(classLoaderCache, classLoaderFactory));
        }
    }

    static class ToolingGlobalScopeServices {
        ToolingGlobalScopeServices() {
        }

        InProcessBuildActionExecuter createBuildActionExecuter(GradleLauncherFactory gradleLauncherFactory, ServiceRegistry services) {
            List<BuildActionRunner> buildActionRunners = services.getAll(BuildActionRunner.class);
            return new InProcessBuildActionExecuter(gradleLauncherFactory, new ChainingBuildActionRunner(buildActionRunners));
        }

        ExecuteBuildActionRunner createExecuteBuildActionRunner() {
            return new ExecuteBuildActionRunner();
        }

        ClassLoaderCache createClassLoaderCache() {
            return new ClassLoaderCache();
        }

        JarCache createJarCache() {
            return new JarCache();
        }
    }
}

