/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.client.DaemonClientFactory;
import org.gradle.launcher.daemon.client.DaemonStartListener;
import org.gradle.launcher.daemon.client.DaemonStopClient;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.context.DaemonInstanceDetails;
import org.gradle.logging.internal.OutputEventRenderer;

public class ShutdownCoordinator
implements DaemonStartListener,
Stoppable {
    private final Set<DaemonInstanceDetails> daemons = new CopyOnWriteArraySet<DaemonInstanceDetails>();
    private final DaemonClientFactory clientFactory;
    private final OutputEventRenderer outputEventRenderer;

    public ShutdownCoordinator(DaemonClientFactory clientFactory, OutputEventRenderer outputEventRenderer) {
        this.clientFactory = clientFactory;
        this.outputEventRenderer = outputEventRenderer;
    }

    public void daemonStarted(DaemonInstanceDetails daemon) {
        this.daemons.add(daemon);
    }

    public void stop() {
        ServiceRegistry clientServices = this.clientFactory.createStopDaemonServices(this.outputEventRenderer, new DaemonParameters(new BuildLayoutParameters()));
        DaemonStopClient client = clientServices.get(DaemonStopClient.class);
        client.gracefulStop(this.daemons);
    }
}

