/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.Platform;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;

public class CommandLineUtil {
    private static final char SPECIAL_QUOTE = '\uefef';
    private static final String WIN_SHELL_SPECIALS = "&<>()@^|";

    public static String specialQuote(String parameter) {
        return CommandLineUtil.quote(parameter, '\uefef');
    }

    public static List<String> toCommandLine(List<String> command) {
        assert (!command.isEmpty());
        return CommandLineUtil.toCommandLine(command.get(0), command.subList(1, command.size()));
    }

    public static List<String> toCommandLine(String command, List<String> parameters) {
        return CommandLineUtil.toCommandLine(command, parameters, Platform.current());
    }

    public static List<String> toCommandLine(String command, List<String> parameters, Platform platform) {
        ArrayList<String> commandLine = ContainerUtil.newArrayListWithCapacity(parameters.size() + 1);
        commandLine.add(FileUtilRt.toSystemDependentName(command, platform.fileSeparator));
        boolean isWindows = platform == Platform.WINDOWS;
        boolean winShell = isWindows && CommandLineUtil.isWinShell(command);
        for (String parameter : parameters) {
            if (isWindows) {
                if (parameter.contains("\"")) {
                    parameter = StringUtil.replace(parameter, "\"", "\\\"");
                } else if (parameter.isEmpty()) {
                    parameter = "\"\"";
                }
            }
            if (winShell && StringUtil.containsAnyChar(parameter, WIN_SHELL_SPECIALS)) {
                parameter = CommandLineUtil.quote(parameter, '\uefef');
            }
            if (CommandLineUtil.isQuoted(parameter, '\uefef')) {
                parameter = CommandLineUtil.quote(parameter.substring(1, parameter.length() - 1), '\"');
            }
            commandLine.add(parameter);
        }
        return commandLine;
    }

    private static boolean isWinShell(String command) {
        return CommandLineUtil.endsWithIgnoreCase(command, ".cmd") || CommandLineUtil.endsWithIgnoreCase(command, ".bat") || "cmd".equalsIgnoreCase(command) || "cmd.exe".equalsIgnoreCase(command);
    }

    private static boolean endsWithIgnoreCase(String str, String suffix) {
        return str.regionMatches(true, str.length() - suffix.length(), suffix, 0, suffix.length());
    }

    private static String quote(String s, char ch) {
        return !CommandLineUtil.isQuoted(s, ch) ? ch + s + ch : s;
    }

    private static boolean isQuoted(String s, char ch) {
        return s.length() >= 2 && s.charAt(0) == ch && s.charAt(s.length() - 1) == ch;
    }
}

