/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Base64Converter;
import com.intellij.util.PathUtilRt;

public class Attachment {
    public static final Attachment[] EMPTY_ARRAY = new Attachment[0];
    private final String myPath;
    private final byte[] myBytes;
    private boolean myIncluded = true;
    private final String myDisplayText;

    public Attachment(String path, String content) {
        this.myPath = path;
        this.myDisplayText = content;
        this.myBytes = Attachment.getBytes(content);
    }

    public Attachment(String path, byte[] bytes, String displayText) {
        this.myPath = path;
        this.myBytes = bytes;
        this.myDisplayText = displayText;
    }

    public static byte[] getBytes(String content) {
        return content.getBytes(CharsetToolkit.UTF8_CHARSET);
    }

    public String getDisplayText() {
        return this.myDisplayText;
    }

    public String getPath() {
        return this.myPath;
    }

    public String getName() {
        return PathUtilRt.getFileName(this.myPath);
    }

    public String getEncodedBytes() {
        return Base64Converter.encode(this.myBytes);
    }

    public boolean isIncluded() {
        return this.myIncluded;
    }

    public void setIncluded(boolean included) {
        this.myIncluded = included;
    }
}

