/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtil;
import java.util.concurrent.atomic.AtomicInteger;

public class FrequentEventDetector {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diagnostic.FrequentEventDetector");
    private long myStartedCounting = System.currentTimeMillis();
    private final AtomicInteger myEventsPosted = new AtomicInteger();
    private final int myEventCountThreshold;
    private final int myTimeSpanMs;
    private final Level myLevel;

    public FrequentEventDetector(int eventCountThreshold, int timeSpanMs) {
        this(eventCountThreshold, timeSpanMs, Level.INFO);
    }

    public FrequentEventDetector(int eventCountThreshold, int timeSpanMs, Level level) {
        this.myEventCountThreshold = eventCountThreshold;
        this.myTimeSpanMs = timeSpanMs;
        this.myLevel = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventHappened() {
        if (this.myEventsPosted.incrementAndGet() > this.myEventCountThreshold) {
            boolean shouldLog = false;
            AtomicInteger atomicInteger = this.myEventsPosted;
            synchronized (atomicInteger) {
                if (this.myEventsPosted.get() > this.myEventCountThreshold) {
                    long timeNow = System.currentTimeMillis();
                    shouldLog = timeNow - this.myStartedCounting < (long)this.myTimeSpanMs;
                    this.myEventsPosted.set(0);
                    this.myStartedCounting = timeNow;
                }
            }
            if (shouldLog) {
                String message = "Too many events posted\n" + ExceptionUtil.getThrowableText(new Throwable());
                if (this.myLevel == Level.INFO) {
                    LOG.info(message);
                } else if (this.myLevel == Level.WARN) {
                    LOG.warn(message);
                } else {
                    LOG.error(message);
                }
            }
        }
    }

    public static enum Level {
        INFO,
        WARN,
        ERROR;

    }
}

