/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.fragments;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.fragments.Fragment;
import com.intellij.openapi.diff.impl.fragments.FragmentHighlighter;
import com.intellij.openapi.diff.impl.fragments.FragmentList;
import com.intellij.openapi.diff.impl.fragments.FragmentListImpl;
import com.intellij.openapi.diff.impl.fragments.LineBlock;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Iterator;

public class LineFragment
extends LineBlock
implements Fragment {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.impl.fragments.LineFragment");
    private final TextRange myRange1;
    private final TextRange myRange2;
    private FragmentList myChildren;
    private boolean myHasLineChildren;

    public LineFragment(int startingLine1, int modifiedLines1, int startingLine2, int modifiedLines2, TextDiffTypeEnum blockType, TextRange range1, TextRange range2) {
        this(startingLine1, modifiedLines1, startingLine2, modifiedLines2, blockType, range1, range2, FragmentList.EMPTY);
    }

    private LineFragment(int startingLine1, int modifiedLines1, int startingLine2, int modifiedLines2, TextDiffTypeEnum blockType, TextRange range1, TextRange range2, FragmentList children) {
        super(startingLine1, modifiedLines1, startingLine2, modifiedLines2, blockType);
        LOG.assertTrue(modifiedLines1 > 0 || modifiedLines2 > 0);
        this.myRange1 = range1;
        this.myRange2 = range2;
        this.myChildren = children;
        this.checkChildren(this.myChildren.iterator());
    }

    @Override
    public TextRange getRange(FragmentSide side) {
        if (side == FragmentSide.SIDE1) {
            return this.myRange1;
        }
        if (side == FragmentSide.SIDE2) {
            return this.myRange2;
        }
        throw new IllegalArgumentException(String.valueOf((Object)side));
    }

    @Override
    public Fragment shift(TextRange range1, TextRange range2, int startingLine1, int startingLine2) {
        return new LineFragment(startingLine1 + this.getStartingLine1(), this.getModifiedLines1(), startingLine2 + this.getStartingLine2(), this.getModifiedLines2(), this.getType(), LineFragment.shiftRange(range1, this.myRange1), LineFragment.shiftRange(range2, this.myRange2), this.myChildren.shift(range1, range2, startingLine1, startingLine2));
    }

    public void adjustTypeFromChildrenTypes() {
        if (this.getType() != TextDiffTypeEnum.CHANGED) {
            return;
        }
        TextDiffTypeEnum candidateType = null;
        Iterator<Fragment> children = this.getChildrenIterator();
        block5: while (children != null && children.hasNext()) {
            TextDiffTypeEnum fragmentType = children.next().getType();
            if (fragmentType == null) continue;
            switch (fragmentType) {
                case CHANGED: {
                    return;
                }
                case INSERT: {
                    if (candidateType == null) {
                        candidateType = TextDiffTypeEnum.INSERT;
                        continue block5;
                    }
                    if (candidateType == TextDiffTypeEnum.INSERT) continue block5;
                    return;
                }
                case DELETED: {
                    if (candidateType == null) {
                        candidateType = TextDiffTypeEnum.DELETED;
                        continue block5;
                    }
                    if (candidateType == TextDiffTypeEnum.DELETED) continue block5;
                    return;
                }
            }
            return;
        }
        if (candidateType != null) {
            this.setType(candidateType);
        }
    }

    static TextRange shiftRange(TextRange shift, TextRange range) {
        int start = shift.getStartOffset();
        int newEnd = start + range.getEndOffset();
        int newStart = start + range.getStartOffset();
        LOG.assertTrue(newStart <= shift.getEndOffset());
        LOG.assertTrue(newEnd <= shift.getEndOffset());
        return new TextRange(newStart, newEnd);
    }

    @Override
    public void highlight(FragmentHighlighter fragmentHighlighter) {
        fragmentHighlighter.highlightLine(this);
    }

    public boolean isOneSide() {
        return this.myRange1.getLength() == 0 || this.myRange2.getLength() == 0;
    }

    public boolean isEqual() {
        return this.getType() == null;
    }

    @Override
    public Fragment getSubfragmentAt(int offset, FragmentSide side, Condition<Fragment> condition) {
        Fragment childFragment = this.myChildren.getFragmentAt(offset, side, condition);
        return childFragment != null ? childFragment : this;
    }

    public Iterator<Fragment> getChildrenIterator() {
        return this.myChildren == null || this.myChildren.isEmpty() ? null : this.myChildren.iterator();
    }

    public DiffString getText(DiffString text, FragmentSide side) {
        TextRange range = this.getRange(side);
        return text.substring(range.getStartOffset(), range.getEndOffset());
    }

    public void addAllDescendantsTo(ArrayList<LineFragment> descendants) {
        if (this.myChildren == null) {
            return;
        }
        Iterator<Fragment> iterator = this.myChildren.iterator();
        while (iterator.hasNext()) {
            Fragment fragment = iterator.next();
            if (!(fragment instanceof LineFragment)) continue;
            LineFragment lineFragment = (LineFragment)fragment;
            descendants.add(lineFragment);
            lineFragment.addAllDescendantsTo(descendants);
        }
    }

    public void setChildren(ArrayList<Fragment> fragments) {
        LOG.assertTrue(this.myChildren == FragmentList.EMPTY);
        ArrayList<Fragment> shifted = FragmentListImpl.shift(fragments, this.myRange1, this.myRange2, this.getStartingLine1(), this.getStartingLine2());
        if (shifted.isEmpty()) {
            return;
        }
        Fragment firstChild = shifted.get(0);
        if (shifted.size() == 1 && this.isSameRanges(firstChild)) {
            if (!(firstChild instanceof LineFragment)) {
                return;
            }
            LineFragment lineFragment = (LineFragment)firstChild;
            this.myChildren = lineFragment.myChildren;
        } else {
            this.myChildren = FragmentListImpl.fromList(shifted);
        }
        this.checkChildren(this.myChildren.iterator());
    }

    private void checkChildren(Iterator<Fragment> iterator) {
        if (this.myChildren.isEmpty()) {
            this.myHasLineChildren = false;
            return;
        }
        boolean hasLineChildren = false;
        boolean hasInlineChildren = false;
        while (iterator.hasNext()) {
            Fragment fragment = iterator.next();
            boolean lineChild = fragment instanceof LineFragment;
            hasLineChildren |= lineChild;
            hasInlineChildren |= !lineChild;
            if (!lineChild) continue;
            LineFragment lineFragment = (LineFragment)fragment;
            LOG.assertTrue(this.getStartingLine1() != lineFragment.getStartingLine1() || this.getModifiedLines1() != lineFragment.getModifiedLines1() || this.getStartingLine2() != lineFragment.getStartingLine2() || this.getModifiedLines2() != lineFragment.getModifiedLines2());
        }
        LOG.assertTrue(hasLineChildren ^ hasInlineChildren);
        this.myHasLineChildren = hasLineChildren;
    }

    private boolean isSameRanges(Fragment fragment) {
        return this.getRange(FragmentSide.SIDE1).equals(fragment.getRange(FragmentSide.SIDE1)) && this.getRange(FragmentSide.SIDE2).equals(fragment.getRange(FragmentSide.SIDE2));
    }

    public boolean isHasLineChildren() {
        return this.myHasLineChildren;
    }

    @Override
    public int getEndLine1() {
        return super.getEndLine1();
    }

    @Override
    public int getEndLine2() {
        return super.getEndLine2();
    }
}

