/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.util.TextRange;

public class Word {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.impl.processing.Word");
    private final DiffString myBaseText;
    private final TextRange myRange;
    private final DiffString myText;

    public Word(String baseText, TextRange range) {
        this(DiffString.create(baseText), range);
    }

    public Word(DiffString baseText, TextRange range) {
        this.myBaseText = baseText;
        this.myRange = range;
        this.myText = this.myBaseText.substring(this.myRange.getStartOffset(), this.myRange.getEndOffset());
        LOG.assertTrue(this.myRange.getStartOffset() >= 0);
        LOG.assertTrue(this.myRange.getEndOffset() >= this.myRange.getStartOffset(), this.myRange);
    }

    public int hashCode() {
        return this.myText.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Word)) {
            return false;
        }
        Word other = (Word)obj;
        return this.getText().equals(other.getText());
    }

    public DiffString getText() {
        return this.myText;
    }

    public DiffString getPrefix(int fromPosition) {
        LOG.assertTrue(fromPosition >= 0, fromPosition);
        int wordStart = this.myRange.getStartOffset();
        LOG.assertTrue(fromPosition <= wordStart, fromPosition + " " + wordStart);
        return this.myBaseText.substring(fromPosition, wordStart);
    }

    public int getEnd() {
        return this.myRange.getEndOffset();
    }

    public int getStart() {
        return this.myRange.getStartOffset();
    }

    public String toString() {
        return this.myText.toString();
    }

    public boolean isWhitespace() {
        return false;
    }

    public boolean atEndOfLine() {
        int start = this.myRange.getStartOffset();
        if (start == 0) {
            return true;
        }
        if (this.myBaseText.charAt(start - 1) == '\n') {
            return true;
        }
        int end = this.myRange.getEndOffset();
        if (end == this.myBaseText.length()) {
            return true;
        }
        return this.myBaseText.charAt(end) == '\n';
    }
}

