/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.string;

import com.intellij.openapi.diff.LineTokenizerBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DiffString
implements CharSequence {
    public static final DiffString EMPTY = new DiffString(new char[0], 0, 0);
    private final char[] myData;
    private final int myStart;
    private final int myLength;
    private int myHash;

    public static DiffString createNullable(String string) {
        if (string == null) {
            return null;
        }
        return DiffString.create(string);
    }

    public static DiffString create(String string) {
        if (string.isEmpty()) {
            return EMPTY;
        }
        return DiffString.create(string.toCharArray());
    }

    static DiffString create(char[] data) {
        return DiffString.create(data, 0, data.length);
    }

    static DiffString create(char[] data, int start, int length) {
        if (length == 0) {
            return EMPTY;
        }
        DiffString.checkBounds(start, length, data.length);
        return new DiffString(data, start, length);
    }

    private DiffString(char[] data, int start, int length) {
        this.myData = data;
        this.myStart = start;
        this.myLength = length;
    }

    @Override
    public int length() {
        return this.myLength;
    }

    @Override
    public boolean isEmpty() {
        return this.myLength == 0;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.myLength) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.data(index);
    }

    public char data(int index) {
        return this.myData[this.myStart + index];
    }

    public DiffString substring(int start) {
        return this.substring(start, this.myLength);
    }

    public DiffString substring(int start, int end) {
        if (start == 0 && end == this.myLength) {
            return this;
        }
        DiffString.checkBounds(start, end - start, this.myLength);
        return DiffString.create(this.myData, this.myStart + start, end - start);
    }

    @Override
    public DiffString subSequence(int start, int end) {
        return this.substring(start, end);
    }

    @Override
    public String toString() {
        return new String(this.myData, this.myStart, this.myLength);
    }

    public DiffString copy() {
        return DiffString.create(Arrays.copyOfRange(this.myData, this.myStart, this.myStart + this.myLength));
    }

    public void copyData(char[] dst, int start) {
        DiffString.checkBounds(start, this.myLength, dst.length);
        System.arraycopy(this.myData, this.myStart, dst, start, this.myLength);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiffString that = (DiffString)o;
        if (this.myLength != that.myLength) {
            return false;
        }
        if (this.hashCode() != that.hashCode()) {
            return false;
        }
        for (int i = 0; i < this.myLength; ++i) {
            if (this.data(i) == that.data(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = this.myHash;
        if (h == 0) {
            h = StringUtil.stringHashCode(this.myData, this.myStart, this.myStart + this.myLength);
            if (h == 0) {
                h = 1;
            }
            this.myHash = h;
        }
        return h;
    }

    public static DiffString concatenateNullable(DiffString s1, DiffString s2) {
        if (s1 == null || s2 == null) {
            if (s1 != null) {
                return s1;
            }
            if (s2 != null) {
                return s2;
            }
            return null;
        }
        return DiffString.concatenate(s1, s2);
    }

    public static DiffString concatenate(DiffString s1, DiffString s2) {
        if (s1.isEmpty()) {
            return s2;
        }
        if (s2.isEmpty()) {
            return s1;
        }
        if (s1.myData == s2.myData && s1.myStart + s1.myLength == s2.myStart) {
            return DiffString.create(s1.myData, s1.myStart, s1.myLength + s2.myLength);
        }
        char[] data = new char[s1.myLength + s2.myLength];
        System.arraycopy(s1.myData, s1.myStart, data, 0, s1.myLength);
        System.arraycopy(s2.myData, s2.myStart, data, s1.myLength, s2.myLength);
        return DiffString.create(data);
    }

    public static boolean canInplaceConcatenate(DiffString s1, DiffString s2) {
        if (s1.isEmpty()) {
            return true;
        }
        if (s2.isEmpty()) {
            return true;
        }
        return s1.myData == s2.myData && s1.myStart + s1.myLength == s2.myStart;
    }

    public static DiffString concatenateCopying(DiffString[] strings) {
        return DiffString.concatenateCopying(strings, 0, strings.length);
    }

    public static DiffString concatenateCopying(DiffString[] strings, int start, int length) {
        DiffString.checkBounds(start, length, strings.length);
        int len = 0;
        for (int i = 0; i < length; ++i) {
            DiffString string = strings[start + i];
            len += string == null ? 0 : string.myLength;
        }
        if (len == 0) {
            return EMPTY;
        }
        char[] data = new char[len];
        int index = 0;
        for (int i = 0; i < length; ++i) {
            DiffString string = strings[start + i];
            if (string == null || string.isEmpty()) continue;
            System.arraycopy(string.myData, string.myStart, data, index, string.myLength);
            index += string.myLength;
        }
        return DiffString.create(data);
    }

    public static DiffString concatenate(DiffString s, char c) {
        if (s.myStart + s.myLength < s.myData.length && s.data(s.myLength) == c) {
            return DiffString.create(s.myData, s.myStart, s.myLength + 1);
        }
        char[] data = new char[s.myLength + 1];
        System.arraycopy(s.myData, s.myStart, data, 0, s.myLength);
        data[s.myLength] = c;
        return DiffString.create(data);
    }

    public static DiffString concatenate(char c, DiffString s) {
        if (s.myStart > 0 && s.data(-1) == c) {
            return DiffString.create(s.myData, s.myStart - 1, s.myLength + 1);
        }
        char[] data = new char[s.myLength + 1];
        System.arraycopy(s.myData, s.myStart, data, 1, s.myLength);
        data[0] = c;
        return DiffString.create(data);
    }

    public static DiffString concatenate(DiffString[] strings) {
        return DiffString.concatenate(strings, 0, strings.length);
    }

    public static DiffString concatenate(DiffString[] strings, int start, int length) {
        DiffString.checkBounds(start, length, strings.length);
        char[] data = null;
        int startIndex = 0;
        int endIndex = 0;
        boolean linearized = true;
        for (int i = 0; i < length; ++i) {
            DiffString string = strings[start + i];
            if (string == null || string.isEmpty()) continue;
            if (data == null) {
                data = string.myData;
                startIndex = string.myStart;
                endIndex = string.myStart + string.myLength;
                continue;
            }
            if (data != string.myData || string.myStart != endIndex) {
                linearized = false;
                break;
            }
            endIndex += string.myLength;
        }
        if (linearized) {
            if (data == null) {
                return EMPTY;
            }
            return DiffString.create(data, startIndex, endIndex - startIndex);
        }
        return DiffString.concatenateCopying(strings, start, length);
    }

    public DiffString append(char c) {
        return DiffString.concatenate(this, c);
    }

    public DiffString preappend(char c) {
        return DiffString.concatenate(c, this);
    }

    public static boolean isWhiteSpace(char c) {
        return StringUtil.isWhiteSpace(c);
    }

    public boolean isEmptyOrSpaces() {
        if (this.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.myLength; ++i) {
            if (DiffString.isWhiteSpace(this.data(i))) continue;
            return false;
        }
        return true;
    }

    public DiffString trim() {
        int start;
        int end = this.myLength;
        for (start = 0; start < end && DiffString.isWhiteSpace(this.data(start)); ++start) {
        }
        while (end > start && DiffString.isWhiteSpace(this.data(end - 1))) {
            --end;
        }
        return this.substring(start, end);
    }

    public DiffString trimLeading() {
        int i;
        for (i = 0; i < this.myLength && DiffString.isWhiteSpace(this.data(i)); ++i) {
        }
        return this.substring(i, this.myLength);
    }

    public DiffString trimTrailing() {
        int end;
        for (end = this.myLength; end > 0 && DiffString.isWhiteSpace(this.data(end - 1)); --end) {
        }
        return this.substring(0, end);
    }

    public DiffString getLeadingSpaces() {
        int i;
        for (i = 0; i < this.myLength && this.data(i) == ' '; ++i) {
        }
        return this.substring(0, i);
    }

    public DiffString skipSpaces() {
        DiffString s = this.trim();
        int count = 0;
        for (int i = 0; i < s.myLength; ++i) {
            if (!DiffString.isWhiteSpace(s.data(i))) continue;
            ++count;
        }
        if (count == 0) {
            return s;
        }
        char[] data = new char[s.myLength - count];
        int index = 0;
        for (int i = 0; i < s.myLength; ++i) {
            if (DiffString.isWhiteSpace(s.data(i))) continue;
            data[index] = s.data(i);
            ++index;
        }
        return DiffString.create(data);
    }

    public int indexOf(char c) {
        return StringUtil.indexOf((CharSequence)this, c);
    }

    public boolean endsWith(char c) {
        if (this.isEmpty()) {
            return false;
        }
        return this.data(this.myLength - 1) == c;
    }

    public static void checkBounds(int start, int length, int maxLength) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (length < 0) {
            throw new StringIndexOutOfBoundsException(length);
        }
        if (start + length > maxLength) {
            throw new StringIndexOutOfBoundsException(start + length);
        }
    }

    public DiffString[] tokenize() {
        return new LineTokenizer(this).execute();
    }

    public static class LineTokenizer
    extends LineTokenizerBase<DiffString> {
        private final DiffString myText;

        public LineTokenizer(DiffString text) {
            this.myText = text;
        }

        public DiffString[] execute() {
            ArrayList lines = new ArrayList();
            this.doExecute(lines);
            return ContainerUtil.toArray(lines, new DiffString[lines.size()]);
        }

        @Override
        protected void addLine(List<DiffString> lines, int start, int end, boolean appendNewLine) {
            if (appendNewLine) {
                lines.add(this.myText.substring(start, end).append('\n'));
            } else {
                lines.add(this.myText.substring(start, end));
            }
        }

        @Override
        protected char charAt(int index) {
            return this.myText.data(index);
        }

        @Override
        protected int length() {
            return this.myText.length();
        }

        @Override
        protected String substring(int start, int end) {
            return this.myText.substring(start, end).toString();
        }
    }
}

