/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.string;

import com.intellij.openapi.diff.impl.string.DiffString;
import java.util.Arrays;

public class DiffStringBuilder
implements CharSequence {
    private char[] myData;
    private int myLength;

    public DiffStringBuilder() {
        this(16);
    }

    public DiffStringBuilder(int len) {
        this.myData = new char[len];
        this.myLength = 0;
    }

    @Override
    public int length() {
        return this.myLength;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.myLength) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.myData[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        DiffString.checkBounds(start, end, this.myLength);
        return DiffString.create(this.myData, start, end - start);
    }

    public DiffString toDiffString() {
        return DiffString.create(this.myData, 0, this.myLength);
    }

    @Override
    public String toString() {
        return this.toDiffString().toString();
    }

    private void ensureCapacityInternal(int neededCapacity) {
        if (neededCapacity > this.myData.length) {
            int newCapacity;
            for (newCapacity = this.myData.length; newCapacity < neededCapacity; newCapacity *= 2) {
            }
            this.myData = Arrays.copyOf(this.myData, newCapacity);
        }
    }

    public void append(DiffString s) {
        if (s.isEmpty()) {
            return;
        }
        this.ensureCapacityInternal(this.myLength + s.length());
        s.copyData(this.myData, this.myLength);
        this.myLength += s.length();
    }
}

