/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import java.util.Date;

public class Clock {
    private static long ourTime = -1L;

    public static long getTime() {
        if (ourTime != -1L) {
            return ourTime;
        }
        return System.currentTimeMillis();
    }

    public static void setTime(long time) {
        ourTime = time;
    }

    public static void setTime(Date date) {
        Clock.setTime(date.getTime());
    }

    public static void setTime(int year, int month, int day) {
        Clock.setTime(year, month, day, 0, 0);
    }

    public static void setTime(int year, int month, int day, int hours, int minutes) {
        Clock.setTime(year, month, day, hours, minutes, 0);
    }

    public static void setTime(int year, int month, int day, int hours, int minutes, int seconds) {
        Clock.setTime(new Date(year - 1900, month, day, hours, minutes, seconds));
    }

    public static void reset() {
        ourTime = -1L;
    }
}

