/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtilRt;
import java.util.HashMap;

public class Conditions {
    public static Condition<Object> TRUE = new Condition<Object>(){

        @Override
        public boolean value(Object object) {
            return true;
        }
    };
    public static Condition<Object> FALSE = new Condition<Object>(){

        @Override
        public boolean value(Object object) {
            return false;
        }
    };

    private Conditions() {
    }

    public static <T> Condition<T> alwaysTrue() {
        return TRUE;
    }

    public static <T> Condition<T> alwaysFalse() {
        return FALSE;
    }

    public static <T> Condition<T> instanceOf(final Class<?> clazz) {
        return new Condition<T>(){

            @Override
            public boolean value(T t) {
                return clazz.isInstance(t);
            }
        };
    }

    public static <T> Condition<T> instanceOf(final Class<?> ... clazz) {
        return new Condition<T>(){

            @Override
            public boolean value(T t) {
                for (Class aClass : clazz) {
                    if (!aClass.isInstance(t)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Condition<T> is(final T option) {
        return new Condition<T>(){

            @Override
            public boolean value(T t) {
                return Comparing.equal(t, option);
            }
        };
    }

    public static <T> Condition<T> oneOf(final T ... options) {
        return new Condition<T>(){

            @Override
            public boolean value(T t) {
                return ArrayUtilRt.find(options, t) >= 0;
            }
        };
    }

    public static <T> Condition<T> not(Condition<T> c) {
        return new Not<T>(c);
    }

    public static <T> Condition<T> and(Condition<T> c1, Condition<T> c2) {
        return new And<T>(c1, c2);
    }

    public static <T> Condition<T> and2(Condition<? super T> c1, Condition<? super T> c2) {
        return new And<T>(c1, c2);
    }

    public static <T> Condition<T> or(Condition<T> c1, Condition<T> c2) {
        return new Or<T>(c1, c2);
    }

    public static <T> Condition<T> or2(Condition<? super T> c1, Condition<? super T> c2) {
        return new Or<T>(c1, c2);
    }

    public static <T> Condition<T> cached(Condition<T> c) {
        return new SoftRefCache<T>(c);
    }

    private static class SoftRefCache<T>
    implements Condition<T> {
        private final HashMap<Integer, Pair<SoftReference<T>, Boolean>> myCache = new HashMap();
        private final Condition<T> myCondition;

        public SoftRefCache(Condition<T> condition) {
            this.myCondition = condition;
        }

        @Override
        public final boolean value(T object) {
            int key = object.hashCode();
            Pair<SoftReference<T>, Boolean> entry = this.myCache.get(key);
            if (entry == null || ((SoftReference)entry.first).get() != object) {
                boolean value = this.myCondition.value(object);
                this.myCache.put(key, Pair.create(new SoftReference<T>(object), value));
                return value;
            }
            return (Boolean)entry.second;
        }
    }

    private static class Or<T>
    implements Condition<T> {
        private final Condition<? super T> t1;
        private final Condition<? super T> t2;

        public Or(Condition<? super T> t1, Condition<? super T> t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        @Override
        public boolean value(T object) {
            return this.t1.value(object) || this.t2.value(object);
        }
    }

    private static class And<T>
    implements Condition<T> {
        private final Condition<? super T> t1;
        private final Condition<? super T> t2;

        public And(Condition<? super T> t1, Condition<? super T> t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        @Override
        public boolean value(T object) {
            return this.t1.value(object) && this.t2.value(object);
        }
    }

    private static class Not<T>
    implements Condition<T> {
        private final Condition<T> myCondition;

        public Not(Condition<T> condition) {
            this.myCondition = condition;
        }

        @Override
        public boolean value(T value) {
            return !this.myCondition.value(value);
        }
    }
}

