/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.NotNullFunction;
import org.jetbrains.annotations.NonNls;

public class NotNullLazyKey<T, H extends UserDataHolder>
extends Key<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("NotNullLazyKey");
    private final NotNullFunction<H, T> myFunction;

    private NotNullLazyKey(@NonNls String name, NotNullFunction<H, T> function) {
        super(name);
        this.myFunction = function;
    }

    public final T getValue(H h) {
        Object data = h.getUserData(this);
        if (data == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            data = this.myFunction.fun(h);
            if (stamp.mayCacheNow()) {
                h.putUserData(this, data);
            }
        }
        return data;
    }

    public static <T, H extends UserDataHolder> NotNullLazyKey<T, H> create(@NonNls String name, NotNullFunction<H, T> function) {
        return new NotNullLazyKey<T, H>(name, function);
    }
}

