/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;

public class ProperTextRange
extends TextRange {
    public ProperTextRange(int startOffset, int endOffset) {
        super(startOffset, endOffset);
        ProperTextRange.assertProperRange(this);
    }

    public ProperTextRange(TextRange range) {
        this(range.getStartOffset(), range.getEndOffset());
    }

    @Override
    public ProperTextRange cutOut(TextRange subRange) {
        assert (subRange.getStartOffset() <= this.getLength()) : subRange + "; this=" + this;
        assert (subRange.getEndOffset() <= this.getLength()) : subRange + "; this=" + this;
        return new ProperTextRange(this.getStartOffset() + subRange.getStartOffset(), Math.min(this.getEndOffset(), this.getStartOffset() + subRange.getEndOffset()));
    }

    @Override
    public ProperTextRange shiftRight(int delta) {
        if (delta == 0) {
            return this;
        }
        return new ProperTextRange(this.getStartOffset() + delta, this.getEndOffset() + delta);
    }

    @Override
    public ProperTextRange grown(int lengthDelta) {
        if (lengthDelta == 0) {
            return this;
        }
        return new ProperTextRange(this.getStartOffset(), this.getEndOffset() + lengthDelta);
    }

    @Override
    public ProperTextRange intersection(TextRange textRange) {
        ProperTextRange.assertProperRange(textRange);
        TextRange range = super.intersection(textRange);
        if (range == null) {
            return null;
        }
        return new ProperTextRange(range);
    }

    @Override
    public ProperTextRange union(TextRange textRange) {
        ProperTextRange.assertProperRange(textRange);
        TextRange range = super.union(textRange);
        return new ProperTextRange(range);
    }

    public static ProperTextRange create(Segment segment) {
        return new ProperTextRange(segment.getStartOffset(), segment.getEndOffset());
    }

    public static ProperTextRange create(int startOffset, int endOffset) {
        return new ProperTextRange(startOffset, endOffset);
    }

    public static ProperTextRange from(int offset, int length) {
        return new ProperTextRange(offset, offset + length);
    }
}

