/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Segment;
import java.io.Serializable;

public class TextRange
implements Segment,
Serializable {
    private static final Logger LOG = Logger.getInstance(TextRange.class);
    private static final long serialVersionUID = -670091356599757430L;
    public static final TextRange EMPTY_RANGE = new TextRange(0, 0);
    private final int myStartOffset;
    private final int myEndOffset;

    public TextRange(int startOffset, int endOffset) {
        this(startOffset, endOffset, true);
    }

    protected TextRange(int startOffset, int endOffset, boolean checkForProperTextRange) {
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        if (checkForProperTextRange) {
            TextRange.assertProperRange(this);
        }
    }

    @Override
    public final int getStartOffset() {
        return this.myStartOffset;
    }

    @Override
    public final int getEndOffset() {
        return this.myEndOffset;
    }

    public final int getLength() {
        return this.myEndOffset - this.myStartOffset;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextRange)) {
            return false;
        }
        TextRange range = (TextRange)obj;
        return this.myStartOffset == range.myStartOffset && this.myEndOffset == range.myEndOffset;
    }

    public int hashCode() {
        return this.myStartOffset + this.myEndOffset;
    }

    public boolean contains(TextRange range) {
        return this.contains((Segment)range);
    }

    public boolean contains(Segment range) {
        return this.containsRange(range.getStartOffset(), range.getEndOffset());
    }

    public boolean containsRange(int startOffset, int endOffset) {
        return this.getStartOffset() <= startOffset && this.getEndOffset() >= endOffset;
    }

    public static boolean containsRange(Segment outer, Segment inner) {
        return outer.getStartOffset() <= inner.getStartOffset() && inner.getEndOffset() <= outer.getEndOffset();
    }

    public boolean containsOffset(int offset) {
        return this.myStartOffset <= offset && offset <= this.myEndOffset;
    }

    public String toString() {
        return "(" + this.myStartOffset + "," + this.myEndOffset + ")";
    }

    public boolean contains(int offset) {
        return this.myStartOffset <= offset && offset < this.myEndOffset;
    }

    public String substring(String str) {
        try {
            return str.substring(this.myStartOffset, this.myEndOffset);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new StringIndexOutOfBoundsException("Can't extract " + this + " range from " + str);
        }
    }

    public CharSequence subSequence(CharSequence str) {
        try {
            return str.subSequence(this.myStartOffset, this.myEndOffset);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Can't extract " + this + " range from " + str);
        }
    }

    public TextRange cutOut(TextRange subRange) {
        assert (subRange.getStartOffset() <= this.getLength()) : subRange + "; this=" + this;
        assert (subRange.getEndOffset() <= this.getLength()) : subRange + "; this=" + this;
        return new TextRange(this.myStartOffset + subRange.getStartOffset(), Math.min(this.myEndOffset, this.myStartOffset + subRange.getEndOffset()));
    }

    public TextRange shiftRight(int delta) {
        if (delta == 0) {
            return this;
        }
        return new TextRange(this.myStartOffset + delta, this.myEndOffset + delta);
    }

    public TextRange grown(int lengthDelta) {
        return TextRange.from(this.myStartOffset, this.getLength() + lengthDelta);
    }

    public static TextRange from(int offset, int length) {
        return TextRange.create(offset, offset + length);
    }

    public static TextRange create(int startOffset, int endOffset) {
        return new TextRange(startOffset, endOffset);
    }

    public static TextRange create(Segment segment) {
        return TextRange.create(segment.getStartOffset(), segment.getEndOffset());
    }

    public static boolean areSegmentsEqual(Segment segment1, Segment segment2) {
        return segment1.getStartOffset() == segment2.getStartOffset() && segment1.getEndOffset() == segment2.getEndOffset();
    }

    public String replace(String original, String replacement) {
        try {
            String beginning = original.substring(0, this.getStartOffset());
            String ending = original.substring(this.getEndOffset(), original.length());
            return beginning + replacement + ending;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new StringIndexOutOfBoundsException("Can't replace " + this + " range from '" + original + "' with '" + replacement + "'");
        }
    }

    public boolean intersects(TextRange textRange) {
        return this.intersects((Segment)textRange);
    }

    public boolean intersects(Segment textRange) {
        return this.intersects(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public boolean intersects(int startOffset, int endOffset) {
        return Math.max(this.myStartOffset, startOffset) <= Math.min(this.myEndOffset, endOffset);
    }

    public boolean intersectsStrict(TextRange textRange) {
        return this.intersectsStrict(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public boolean intersectsStrict(int startOffset, int endOffset) {
        return Math.max(this.myStartOffset, startOffset) < Math.min(this.myEndOffset, endOffset);
    }

    public TextRange intersection(TextRange range) {
        if (!this.intersects(range)) {
            return null;
        }
        return new TextRange(Math.max(this.myStartOffset, range.getStartOffset()), Math.min(this.myEndOffset, range.getEndOffset()));
    }

    public boolean isEmpty() {
        return this.myStartOffset >= this.myEndOffset;
    }

    public TextRange union(TextRange textRange) {
        return new TextRange(Math.min(this.myStartOffset, textRange.getStartOffset()), Math.max(this.myEndOffset, textRange.getEndOffset()));
    }

    public boolean equalsToRange(int startOffset, int endOffset) {
        return startOffset == this.myStartOffset && endOffset == this.myEndOffset;
    }

    public static TextRange allOf(String s) {
        return new TextRange(0, s.length());
    }

    public static void assertProperRange(Segment range) throws AssertionError {
        TextRange.assertProperRange(range, "");
    }

    public static void assertProperRange(Segment range, Object message) throws AssertionError {
        TextRange.assertProperRange(range.getStartOffset(), range.getEndOffset(), message);
    }

    public static void assertProperRange(int startOffset, int endOffset, Object message) {
        if (startOffset > endOffset) {
            LOG.error("Invalid range specified: (" + startOffset + "," + endOffset + "); " + message);
        }
        if (startOffset < 0) {
            LOG.error("Negative start offset: (" + startOffset + "," + endOffset + "); " + message);
        }
    }
}

