/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.annotations.NonNls;

public class TraceableDisposable {
    private final Throwable CREATE_TRACE;
    private Throwable KILL_TRACE;

    public TraceableDisposable(Throwable creation) {
        this.CREATE_TRACE = creation;
    }

    public void kill(@NonNls String msg) {
        if (this.CREATE_TRACE != null) {
            this.KILL_TRACE = new Throwable(msg);
        }
    }

    public void throwDisposalError(@NonNls String msg) throws RuntimeException {
        throw new DisposalException(msg);
    }

    public String getStackTrace() {
        StringWriter out = new StringWriter();
        new DisposalException("").printStackTrace(new PrintWriter(out));
        return out.toString();
    }

    private class DisposalException
    extends RuntimeException {
        private DisposalException(String message) {
            super(message);
        }

        @Override
        public void printStackTrace(PrintStream s) {
            PrintWriter writer = new PrintWriter(s);
            this.printStackTrace(writer);
            writer.flush();
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            if (TraceableDisposable.this.CREATE_TRACE != null) {
                s.println("--------------Creation trace: ");
                TraceableDisposable.this.CREATE_TRACE.printStackTrace(s);
            }
            if (TraceableDisposable.this.KILL_TRACE != null) {
                s.println("--------------Kill trace: ");
                TraceableDisposable.this.KILL_TRACE.printStackTrace(s);
            }
            s.println("-------------Own trace:");
            super.printStackTrace(s);
        }
    }
}

