/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;

public abstract class VolatileNullableLazyValue<T>
extends NullableLazyValue<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("VolatileNullableLazyValue");
    private volatile boolean myComputed;
    private volatile T myValue;

    @Override
    protected abstract T compute();

    @Override
    public T getValue() {
        T value = this.myValue;
        if (!this.myComputed) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            value = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = value;
                this.myComputed = true;
            }
        }
        return value;
    }
}

