/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NonNls;

public class FileUtilRt {
    private static final int KILOBYTE = 1024;
    public static final int MEGABYTE = 0x100000;
    public static final int LARGE_FOR_CONTENT_LOADING = Math.max(0x1400000, FileUtilRt.getUserFileSizeLimit());
    private static final int MAX_FILE_IO_ATTEMPTS = 10;
    private static final boolean USE_FILE_CHANNELS = "true".equalsIgnoreCase(System.getProperty("idea.fs.useChannels"));
    public static final FileFilter ALL_FILES = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return true;
        }
    };
    public static final FileFilter ALL_DIRECTORIES = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    protected static final ThreadLocal<byte[]> BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[20480];
        }
    };
    private static String ourCanonicalTempPathCache = null;

    public static String getExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        return fileName.substring(index + 1);
    }

    public static CharSequence getExtension(CharSequence fileName) {
        int index = StringUtilRt.lastIndexOf(fileName, '.', 0, fileName.length());
        if (index < 0) {
            return "";
        }
        return fileName.subSequence(index + 1, fileName.length());
    }

    public static boolean extensionEquals(String fileName, String extension) {
        int extLen = extension.length();
        if (extLen == 0) {
            return fileName.indexOf(46) == -1;
        }
        int extStart = fileName.length() - extLen;
        return extStart >= 1 && fileName.charAt(extStart - 1) == '.' && fileName.regionMatches(!SystemInfoRt.isFileSystemCaseSensitive, extStart, extension, 0, extLen);
    }

    public static String toSystemDependentName(@NonNls String fileName) {
        return FileUtilRt.toSystemDependentName(fileName, File.separatorChar);
    }

    public static String toSystemDependentName(@NonNls String fileName, char separatorChar) {
        return fileName.replace('/', separatorChar).replace('\\', separatorChar);
    }

    public static String toSystemIndependentName(@NonNls String fileName) {
        return fileName.replace('\\', '/');
    }

    public static String getRelativePath(File base, File file) {
        if (base == null || file == null) {
            return null;
        }
        if (!base.isDirectory() && (base = base.getParentFile()) == null) {
            return null;
        }
        if (base.equals(file)) {
            return ".";
        }
        String filePath = file.getAbsolutePath();
        String basePath = base.getAbsolutePath();
        return FileUtilRt.getRelativePath(basePath, filePath, File.separatorChar);
    }

    public static String getRelativePath(String basePath, String filePath, char separator) {
        return FileUtilRt.getRelativePath(basePath, filePath, separator, SystemInfoRt.isFileSystemCaseSensitive);
    }

    public static String getRelativePath(String basePath, String filePath, char separator, boolean caseSensitive) {
        int len;
        CharComparingStrategy strategy;
        basePath = FileUtilRt.ensureEnds(basePath, separator);
        if (caseSensitive ? basePath.equals(FileUtilRt.ensureEnds(filePath, separator)) : basePath.equalsIgnoreCase(FileUtilRt.ensureEnds(filePath, separator))) {
            return ".";
        }
        int lastSeparatorIndex = 0;
        CharComparingStrategy charComparingStrategy = strategy = caseSensitive ? CharComparingStrategy.IDENTITY : CharComparingStrategy.CASE_INSENSITIVE;
        for (len = 0; len < filePath.length() && len < basePath.length() && strategy.charsEqual(filePath.charAt(len), basePath.charAt(len)); ++len) {
            if (basePath.charAt(len) != separator) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i = len; i < basePath.length(); ++i) {
            if (basePath.charAt(i) != separator) continue;
            relativePath.append("..");
            relativePath.append(separator);
        }
        relativePath.append(filePath.substring(lastSeparatorIndex + 1));
        return relativePath.toString();
    }

    private static String ensureEnds(String s, char endsWith) {
        return StringUtilRt.endsWithChar(s, endsWith) ? s : s + endsWith;
    }

    public static String getNameWithoutExtension(String name) {
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    public static File createTempDirectory(@NonNls String prefix, @NonNls String suffix) throws IOException {
        return FileUtilRt.createTempDirectory(prefix, suffix, true);
    }

    public static File createTempDirectory(@NonNls String prefix, @NonNls String suffix, boolean deleteOnExit) throws IOException {
        File dir = new File(FileUtilRt.getTempDirectory());
        return FileUtilRt.createTempDirectory(dir, prefix, suffix, deleteOnExit);
    }

    public static File createTempDirectory(File dir, @NonNls String prefix, @NonNls String suffix) throws IOException {
        return FileUtilRt.createTempDirectory(dir, prefix, suffix, true);
    }

    public static File createTempDirectory(File dir, @NonNls String prefix, @NonNls String suffix, boolean deleteOnExit) throws IOException {
        File file = FileUtilRt.doCreateTempFile(dir, prefix, suffix, true);
        if (deleteOnExit) {
            file.deleteOnExit();
        }
        if (!file.isDirectory()) {
            throw new IOException("Cannot create directory: " + file);
        }
        return file;
    }

    public static File createTempFile(@NonNls String prefix, @NonNls String suffix) throws IOException {
        return FileUtilRt.createTempFile(prefix, suffix, false);
    }

    public static File createTempFile(@NonNls String prefix, @NonNls String suffix, boolean deleteOnExit) throws IOException {
        File dir = new File(FileUtilRt.getTempDirectory());
        return FileUtilRt.createTempFile(dir, prefix, suffix, true, deleteOnExit);
    }

    public static File createTempFile(@NonNls File dir, @NonNls String prefix, @NonNls String suffix) throws IOException {
        return FileUtilRt.createTempFile(dir, prefix, suffix, true, true);
    }

    public static File createTempFile(@NonNls File dir, @NonNls String prefix, @NonNls String suffix, boolean create) throws IOException {
        return FileUtilRt.createTempFile(dir, prefix, suffix, create, true);
    }

    public static File createTempFile(@NonNls File dir, @NonNls String prefix, @NonNls String suffix, boolean create, boolean deleteOnExit) throws IOException {
        File file = FileUtilRt.doCreateTempFile(dir, prefix, suffix, false);
        if (deleteOnExit) {
            file.deleteOnExit();
        }
        if (!create && !file.delete() && file.exists()) {
            throw new IOException("Cannot delete file: " + file);
        }
        return file;
    }

    private static File doCreateTempFile(File dir, @NonNls String prefix, @NonNls String suffix, boolean isDirectory) throws IOException {
        dir.mkdirs();
        if (prefix.length() < 3) {
            prefix = (prefix + "___").substring(0, 3);
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        int exceptionsCount = 0;
        while (true) {
            try {
                File temp = FileUtilRt.createTemp(prefix, suffix, dir, isDirectory);
                return FileUtilRt.normalizeFile(temp);
            }
            catch (IOException e) {
                if (++exceptionsCount < 100) continue;
                throw e;
            }
            break;
        }
    }

    private static File createTemp(String prefix, String suffix, File directory, boolean isDirectory) throws IOException {
        boolean success;
        File f;
        prefix = new File(prefix).getName();
        int i = 0;
        do {
            String name;
            if (!(name = prefix + i + suffix).equals((f = new File(directory, name)).getName())) {
                throw new IOException("Unable to create temporary file " + f + " for name " + name);
            }
            ++i;
        } while (f.exists());
        boolean bl = success = isDirectory ? f.mkdir() : f.createNewFile();
        if (!success) {
            throw new IOException("Unable to create temporary file " + f);
        }
        return f;
    }

    private static File normalizeFile(File temp) throws IOException {
        File canonical = temp.getCanonicalFile();
        return SystemInfoRt.isWindows && canonical.getAbsolutePath().contains(" ") ? temp.getAbsoluteFile() : canonical;
    }

    public static String getTempDirectory() {
        if (ourCanonicalTempPathCache == null) {
            ourCanonicalTempPathCache = FileUtilRt.calcCanonicalTempPath();
        }
        return ourCanonicalTempPathCache;
    }

    private static String calcCanonicalTempPath() {
        File file = new File(System.getProperty("java.io.tmpdir"));
        try {
            String canonical = file.getCanonicalPath();
            if (!SystemInfoRt.isWindows || !canonical.contains(" ")) {
                return canonical;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.getAbsolutePath();
    }

    public static void resetCanonicalTempPathCache(String tempPath) {
        ourCanonicalTempPathCache = tempPath;
    }

    public static File generateRandomTemporaryPath() throws IOException {
        File file = new File(FileUtilRt.getTempDirectory(), UUID.randomUUID().toString());
        for (int i = 0; file.exists() && i < 5; ++i) {
            file = new File(FileUtilRt.getTempDirectory(), UUID.randomUUID().toString());
        }
        if (file.exists()) {
            throw new IOException("Couldn't generate unique random path.");
        }
        return FileUtilRt.normalizeFile(file);
    }

    public static void setExecutableAttribute(String path, boolean executableFlag) throws IOException {
        File file = new File(path);
        if (!file.setExecutable(executableFlag) && file.canExecute() != executableFlag) {
            FileUtilRt.logger().warn("Can't set executable attribute of '" + path + "' to " + executableFlag);
        }
    }

    public static String loadFile(File file) throws IOException {
        return FileUtilRt.loadFile(file, null, false);
    }

    public static String loadFile(File file, boolean convertLineSeparators) throws IOException {
        return FileUtilRt.loadFile(file, null, convertLineSeparators);
    }

    public static String loadFile(File file, @NonNls String encoding) throws IOException {
        return FileUtilRt.loadFile(file, encoding, false);
    }

    public static String loadFile(File file, @NonNls String encoding, boolean convertLineSeparators) throws IOException {
        String s = new String(FileUtilRt.loadFileText(file, encoding));
        return convertLineSeparators ? StringUtilRt.convertLineSeparators(s) : s;
    }

    public static char[] loadFileText(File file) throws IOException {
        return FileUtilRt.loadFileText(file, (String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] loadFileText(File file, @NonNls String encoding) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        InputStreamReader reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader((InputStream)stream, encoding);
        try {
            char[] cArray = FileUtilRt.loadText(reader, (int)file.length());
            return cArray;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] loadFileText(File file, @NonNls Charset encoding) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        try {
            char[] cArray = FileUtilRt.loadText(reader, (int)file.length());
            return cArray;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    public static char[] loadText(Reader reader, int length) throws IOException {
        int count;
        int n;
        char[] chars = new char[length];
        for (count = 0; count < chars.length && (n = reader.read(chars, count, chars.length - count)) > 0; count += n) {
        }
        if (count == chars.length) {
            return chars;
        }
        char[] newChars = new char[count];
        System.arraycopy(chars, 0, newChars, 0, count);
        return newChars;
    }

    public static List<String> loadLines(File file) throws IOException {
        return FileUtilRt.loadLines(file.getPath());
    }

    public static List<String> loadLines(File file, @NonNls String encoding) throws IOException {
        return FileUtilRt.loadLines(file.getPath(), encoding);
    }

    public static List<String> loadLines(String path) throws IOException {
        return FileUtilRt.loadLines(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> loadLines(String path, @NonNls String encoding) throws IOException {
        FileInputStream stream = new FileInputStream(path);
        try {
            List<String> list;
            InputStreamReader in = encoding == null ? new InputStreamReader(stream) : new InputStreamReader((InputStream)stream, encoding);
            BufferedReader reader = new BufferedReader(in);
            try {
                list = FileUtilRt.loadLines(reader);
            }
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
            reader.close();
            return list;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    public static List<String> loadLines(BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    public static byte[] loadBytes(InputStream stream) throws IOException {
        int n;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] bytes = BUFFER.get();
        while ((n = stream.read(bytes, 0, bytes.length)) > 0) {
            buffer.write(bytes, 0, n);
        }
        buffer.close();
        return buffer.toByteArray();
    }

    public static boolean isTooLarge(long len) {
        return len > (long)LARGE_FOR_CONTENT_LOADING;
    }

    public static byte[] loadBytes(InputStream stream, int length) throws IOException {
        int n;
        byte[] bytes = new byte[length];
        for (int count = 0; count < length && (n = stream.read(bytes, count, length - count)) > 0; count += n) {
        }
        return bytes;
    }

    public static File getParentFile(File file) {
        int skipCount = 0;
        File parentFile = file;
        while (true) {
            if ((parentFile = parentFile.getParentFile()) == null) {
                return null;
            }
            if (".".equals(parentFile.getName())) continue;
            if ("..".equals(parentFile.getName())) {
                ++skipCount;
                continue;
            }
            if (skipCount <= 0) break;
            --skipCount;
        }
        return parentFile;
    }

    public static boolean delete(File file) {
        if (NIOReflect.IS_AVAILABLE) {
            return FileUtilRt.deleteRecursivelyNIO(file);
        }
        return FileUtilRt.deleteRecursively(file);
    }

    protected static boolean deleteRecursivelyNIO(File file) {
        try {
            Object pathObject = NIOReflect.ourFileToPathMethod.invoke((Object)file, new Object[0]);
            NIOReflect.ourFilesWalkMethod.invoke(null, pathObject, NIOReflect.ourDeletionVisitor);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null || !NIOReflect.ourNoSuchFileExceptionClass.isInstance(cause)) {
                FileUtilRt.logger().info(e);
                return false;
            }
        }
        catch (Exception e) {
            FileUtilRt.logger().info(e);
            return false;
        }
        return true;
    }

    private static boolean deleteRecursively(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File child : files) {
                if (FileUtilRt.deleteRecursively(child)) continue;
                return false;
            }
        }
        return FileUtilRt.deleteFile(file);
    }

    public static <T, E extends Throwable> T doIOOperation(RepeatableIOOperation<T, E> ioTask) throws E {
        for (int i = 10; i > 0; --i) {
            T result = ioTask.execute(i == 1);
            if (result != null) {
                return result;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static boolean deleteFile(final File file) {
        Boolean result = FileUtilRt.doIOOperation(new RepeatableIOOperation<Boolean, RuntimeException>(){

            @Override
            public Boolean execute(boolean lastAttempt) {
                if (file.delete() || !file.exists()) {
                    return Boolean.TRUE;
                }
                if (lastAttempt) {
                    return Boolean.FALSE;
                }
                return null;
            }
        });
        return Boolean.TRUE.equals(result);
    }

    public static boolean ensureCanCreateFile(File file) {
        if (file.exists()) {
            return file.canWrite();
        }
        if (!FileUtilRt.createIfNotExists(file)) {
            return false;
        }
        return FileUtilRt.delete(file);
    }

    public static boolean createIfNotExists(File file) {
        if (file.exists()) {
            return true;
        }
        try {
            if (!FileUtilRt.createParentDirs(file)) {
                return false;
            }
            FileOutputStream s = new FileOutputStream(file);
            ((OutputStream)s).close();
            return true;
        }
        catch (IOException e) {
            FileUtilRt.logger().info(e);
            return false;
        }
    }

    public static boolean createParentDirs(File file) {
        File parentFile;
        if (!file.exists() && (parentFile = file.getParentFile()) != null) {
            return FileUtilRt.createDirectory(parentFile);
        }
        return true;
    }

    public static boolean createDirectory(File path) {
        return path.isDirectory() || path.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File fromFile, File toFile) throws IOException {
        if (!FileUtilRt.ensureCanCreateFile(toFile)) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(toFile);
        try {
            FileInputStream fis = new FileInputStream(fromFile);
            try {
                FileUtilRt.copy(fis, fos);
            }
            finally {
                fis.close();
            }
        }
        finally {
            fos.close();
        }
        long timeStamp = fromFile.lastModified();
        if (timeStamp < 0L) {
            FileUtilRt.logger().warn("Invalid timestamp " + timeStamp + " of '" + fromFile + "'");
        } else if (!toFile.setLastModified(timeStamp)) {
            FileUtilRt.logger().warn("Unable to set timestamp " + timeStamp + " to '" + toFile + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        block8: {
            int read;
            if (USE_FILE_CHANNELS && inputStream instanceof FileInputStream && outputStream instanceof FileOutputStream) {
                FileChannel fromChannel = ((FileInputStream)inputStream).getChannel();
                try {
                    FileChannel toChannel = ((FileOutputStream)outputStream).getChannel();
                    try {
                        fromChannel.transferTo(0L, Long.MAX_VALUE, toChannel);
                        break block8;
                    }
                    finally {
                        toChannel.close();
                    }
                }
                finally {
                    fromChannel.close();
                }
            }
            byte[] buffer = BUFFER.get();
            while ((read = inputStream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, read);
            }
        }
    }

    public static int getUserFileSizeLimit() {
        try {
            return Integer.parseInt(System.getProperty("idea.max.intellisense.filesize")) * 1024;
        }
        catch (NumberFormatException e) {
            return 2560000;
        }
    }

    private static LoggerRt logger() {
        return LoggerRt.getInstance("#com.intellij.openapi.util.io.FileUtilRt");
    }

    private static interface CharComparingStrategy {
        public static final CharComparingStrategy IDENTITY = new CharComparingStrategy(){

            @Override
            public boolean charsEqual(char ch1, char ch2) {
                return ch1 == ch2;
            }
        };
        public static final CharComparingStrategy CASE_INSENSITIVE = new CharComparingStrategy(){

            @Override
            public boolean charsEqual(char ch1, char ch2) {
                return StringUtilRt.charsEqualIgnoreCase(ch1, ch2);
            }
        };

        public boolean charsEqual(char var1, char var2);
    }

    public static interface RepeatableIOOperation<T, E extends Throwable> {
        public T execute(boolean var1) throws E;
    }

    protected static final class NIOReflect {
        static final boolean IS_AVAILABLE;
        private static Method ourFilesDeleteIfExistsMethod;
        private static Method ourFilesWalkMethod;
        private static Method ourFileToPathMethod;
        private static Method ourPathToFileMethod;
        private static Object ourDeletionVisitor;
        private static Class ourNoSuchFileExceptionClass;
        private static Class ourAccessDeniedExceptionClass;

        protected NIOReflect() {
        }

        static {
            boolean initSuccess = false;
            try {
                Class<?> pathClass = Class.forName("java.nio.file.Path");
                Class<?> visitorClass = Class.forName("java.nio.file.FileVisitor");
                Class<?> filesClass = Class.forName("java.nio.file.Files");
                ourNoSuchFileExceptionClass = Class.forName("java.nio.file.NoSuchFileException");
                ourAccessDeniedExceptionClass = Class.forName("java.nio.file.AccessDeniedException");
                ourFileToPathMethod = Class.forName("java.io.File").getMethod("toPath", new Class[0]);
                ourPathToFileMethod = pathClass.getMethod("toFile", new Class[0]);
                ourFilesWalkMethod = filesClass.getMethod("walkFileTree", pathClass, visitorClass);
                ourFilesDeleteIfExistsMethod = filesClass.getMethod("deleteIfExists", pathClass);
                Class<?> fileVisitResultClass = Class.forName("java.nio.file.FileVisitResult");
                final Object Result_Continue = fileVisitResultClass.getDeclaredField("CONTINUE").get(null);
                final Object Result_Terminate = fileVisitResultClass.getDeclaredField("TERMINATE").get(null);
                ourDeletionVisitor = Proxy.newProxyInstance(FileUtilRt.class.getClassLoader(), new Class[]{visitorClass}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (args.length == 2) {
                            Object second = args[1];
                            if (second instanceof Throwable) {
                                throw (Throwable)second;
                            }
                            String methodName = method.getName();
                            if (("visitFile".equals(methodName) || "postVisitDirectory".equals(methodName)) && !this.performDelete(args[0])) {
                                return Result_Terminate;
                            }
                        }
                        return Result_Continue;
                    }

                    private boolean performDelete(final Object fileObject) {
                        Boolean result = FileUtilRt.doIOOperation(new RepeatableIOOperation<Boolean, RuntimeException>(){

                            @Override
                            public Boolean execute(boolean lastAttempt) {
                                block8: {
                                    try {
                                        ourFilesDeleteIfExistsMethod.invoke(null, fileObject);
                                        return Boolean.TRUE;
                                    }
                                    catch (InvocationTargetException e) {
                                        Throwable cause = e.getCause();
                                        if (!(cause instanceof IOException)) {
                                            return Boolean.FALSE;
                                        }
                                        if (!ourAccessDeniedExceptionClass.isInstance(cause)) break block8;
                                        try {
                                            File file = (File)ourPathToFileMethod.invoke(fileObject, new Object[0]);
                                            if (file == null) {
                                                return Boolean.FALSE;
                                            }
                                            if (file.delete() || !file.exists()) {
                                                return Boolean.TRUE;
                                            }
                                        }
                                        catch (Throwable ignored) {
                                            return Boolean.FALSE;
                                        }
                                    }
                                    catch (IllegalAccessException e) {
                                        return Boolean.FALSE;
                                    }
                                }
                                return lastAttempt ? Boolean.FALSE : null;
                            }
                        });
                        return Boolean.TRUE.equals(result);
                    }
                });
                initSuccess = true;
            }
            catch (Throwable ignored) {
                FileUtilRt.logger().info("Was not able to detect NIO API");
                ourFileToPathMethod = null;
                ourFilesWalkMethod = null;
                ourFilesDeleteIfExistsMethod = null;
                ourDeletionVisitor = null;
                ourNoSuchFileExceptionClass = null;
            }
            IS_AVAILABLE = initSuccess;
        }
    }
}

