/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io.win32;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.win32.FileInfo;
import com.intellij.util.SystemProperties;
import com.intellij.util.lang.UrlClassLoader;

public class IdeaWin32 {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.io.win32.IdeaWin32");
    private static final boolean DEBUG_ENABLED = LOG.isDebugEnabled();
    private static final IdeaWin32 ourInstance;

    public static boolean isAvailable() {
        return ourInstance != null;
    }

    public static IdeaWin32 getInstance() {
        if (!IdeaWin32.isAvailable()) {
            throw new IllegalStateException("Native filesystem for Windows is not loaded");
        }
        return ourInstance;
    }

    private IdeaWin32() {
        IdeaWin32.initIDs();
    }

    private static native void initIDs();

    public FileInfo getInfo(String path) {
        path = path.replace('/', '\\');
        if (DEBUG_ENABLED) {
            LOG.debug("getInfo(" + path + ")");
            long t = System.nanoTime();
            FileInfo result = this.getInfo0(path);
            t = (System.nanoTime() - t) / 1000L;
            LOG.debug("  " + t + " mks");
            return result;
        }
        return this.getInfo0(path);
    }

    public String resolveSymLink(String path) {
        path = path.replace('/', '\\');
        if (DEBUG_ENABLED) {
            LOG.debug("resolveSymLink(" + path + ")");
            long t = System.nanoTime();
            String result = this.resolveSymLink0(path);
            t = (System.nanoTime() - t) / 1000L;
            LOG.debug("  " + t + " mks");
            return result;
        }
        return this.resolveSymLink0(path);
    }

    public FileInfo[] listChildren(String path) {
        path = path.replace('/', '\\');
        if (DEBUG_ENABLED) {
            LOG.debug("list(" + path + ")");
            long t = System.nanoTime();
            FileInfo[] children = this.listChildren0(path);
            t = (System.nanoTime() - t) / 1000L;
            LOG.debug("  " + (children == null ? -1 : children.length) + " children, " + t + " mks");
            return children;
        }
        return this.listChildren0(path);
    }

    private native FileInfo getInfo0(String var1);

    private native String resolveSymLink0(String var1);

    private native FileInfo[] listChildren0(String var1);

    static {
        IdeaWin32 instance = null;
        if (SystemInfo.isWin2kOrNewer && SystemProperties.getBooleanProperty("idea.use.native.fs.for.win", true)) {
            try {
                UrlClassLoader.loadPlatformLibrary("IdeaWin32");
                instance = new IdeaWin32();
                LOG.info("Native filesystem for Windows is operational");
            }
            catch (Throwable t) {
                LOG.error("Failed to initialize native filesystem for Windows", t);
            }
        }
        ourInstance = instance;
    }
}

