/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.objectTree.ObjectNode;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.openapi.util.objectTree.ObjectTreeListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.Equality;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public final class ObjectTree<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectTree");
    private final List<ObjectTreeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Set<T> myRootObjects = ContainerUtil.newIdentityTroveSet();
    private final Map<T, ObjectNode<T>> myObject2NodeMap = ContainerUtil.newIdentityTroveMap();
    private final List<ObjectNode<T>> myExecutedNodes = new ArrayList<ObjectNode<T>>();
    private final List<T> myExecutedUnregisteredNodes = new ArrayList<T>();
    final Object treeLock = new Object();
    private final AtomicLong myModification = new AtomicLong(0L);

    ObjectNode<T> getNode(T object) {
        return this.myObject2NodeMap.get(object);
    }

    ObjectNode<T> putNode(T object, ObjectNode<T> node) {
        return node == null ? this.myObject2NodeMap.remove(object) : this.myObject2NodeMap.put(object, node);
    }

    final List<ObjectNode<T>> getNodesInExecution() {
        return this.myExecutedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(T parent, T child) {
        Object object = this.treeLock;
        synchronized (object) {
            ObjectNode<T> parentNode = this.getOrCreateNodeFor(parent, null);
            ObjectNode<T> childNode = this.getNode(child);
            if (childNode == null) {
                childNode = this.createNodeFor(child, parentNode, Disposer.isDebugMode() ? new Throwable() : null);
            } else {
                ObjectNode<T> oldParent = childNode.getParent();
                if (oldParent != null) {
                    oldParent.removeChild(childNode);
                }
            }
            this.myRootObjects.remove(child);
            this.checkWasNotAddedAlready(childNode, child);
            parentNode.addChild(childNode);
            this.fireRegistered(childNode.getObject());
        }
    }

    private void checkWasNotAddedAlready(ObjectNode<T> childNode, T child) {
        boolean childIsInTree;
        ObjectNode<T> parent = childNode.getParent();
        boolean bl = childIsInTree = parent != null;
        if (!childIsInTree) {
            return;
        }
        while (parent != null) {
            if (parent.getObject() == child) {
                LOG.error(child + " was already added as a child of: " + parent);
            }
            parent = parent.getParent();
        }
    }

    private ObjectNode<T> getOrCreateNodeFor(T object, ObjectNode<T> defaultParent) {
        ObjectNode<T> node = this.getNode(object);
        if (node != null) {
            return node;
        }
        return this.createNodeFor(object, defaultParent, Disposer.isDebugMode() ? new Throwable() : null);
    }

    private ObjectNode<T> createNodeFor(T object, ObjectNode<T> parentNode, Throwable trace) {
        ObjectNode<T> newNode = new ObjectNode<T>(this, parentNode, object, this.getNextModification(), trace);
        if (parentNode == null) {
            this.myRootObjects.add(object);
        }
        this.putNode(object, newNode);
        return newNode;
    }

    private long getNextModification() {
        return this.myModification.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean executeAll(T object, boolean disposeTree, ObjectTreeAction<T> action, boolean processUnregistered) {
        ObjectNode<T> node;
        Object object2 = this.treeLock;
        synchronized (object2) {
            node = this.getNode(object);
        }
        if (node == null) {
            if (processUnregistered) {
                this.executeUnregistered(object, action);
                return true;
            }
            return false;
        }
        node.execute(disposeTree, action);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> void executeActionWithRecursiveGuard(T object, List<T> recursiveGuard, ObjectTreeAction<T> action) {
        List<T> list = recursiveGuard;
        synchronized (list) {
            if (ArrayUtil.indexOf(recursiveGuard, object, Equality.IDENTITY) != -1) {
                return;
            }
            recursiveGuard.add(object);
        }
        try {
            action.execute(object);
        }
        finally {
            list = recursiveGuard;
            synchronized (list) {
                int i = ArrayUtil.lastIndexOf(recursiveGuard, object, Equality.IDENTITY);
                assert (i != -1);
                recursiveGuard.remove(i);
            }
        }
    }

    private void executeUnregistered(T object, ObjectTreeAction<T> action) {
        ObjectTree.executeActionWithRecursiveGuard(object, this.myExecutedUnregisteredNodes, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeChildAndReplace(T toExecute, T toReplace, boolean disposeTree, ObjectTreeAction<T> action) {
        T parentObject;
        ObjectNode<T> toExecuteNode;
        Object object = this.treeLock;
        synchronized (object) {
            toExecuteNode = this.getNode(toExecute);
            assert (toExecuteNode != null) : "Object " + toExecute + " wasn't registered or already disposed";
            ObjectNode<T> parent = toExecuteNode.getParent();
            assert (parent != null) : "Object " + toExecute + " is not connected to the tree - doesn't have parent";
            parentObject = parent.getObject();
        }
        toExecuteNode.execute(disposeTree, action);
        this.register(parentObject, toReplace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(T object) {
        Object object2 = this.treeLock;
        synchronized (object2) {
            return this.getNode(object) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertNoReferenceKeptInTree(T disposable) {
        Object object = this.treeLock;
        synchronized (object) {
            Collection<ObjectNode<T>> nodes = this.myObject2NodeMap.values();
            for (ObjectNode<T> node : nodes) {
                node.assertNoReferencesKept(disposable);
            }
        }
    }

    void removeRootObject(T object) {
        this.myRootObjects.remove(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertIsEmpty(boolean throwError) {
        Object object = this.treeLock;
        synchronized (object) {
            for (T object2 : this.myRootObjects) {
                ObjectNode<T> objectNode;
                if (object2 == null || (objectNode = this.getNode(object2)) == null) continue;
                while (objectNode.getParent() != null) {
                    objectNode = objectNode.getParent();
                }
                Throwable trace = objectNode.getTrace();
                RuntimeException exception = new RuntimeException("Memory leak detected: " + object2 + " of class " + object2.getClass() + "\nSee the cause for the corresponding Disposer.register() stacktrace:\n", trace);
                if (throwError) {
                    throw exception;
                }
                LOG.error(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.treeLock;
        synchronized (object) {
            return this.myRootObjects.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<T> getRootObjects() {
        Object object = this.treeLock;
        synchronized (object) {
            return this.myRootObjects;
        }
    }

    void addListener(ObjectTreeListener listener) {
        this.myListeners.add(listener);
    }

    void removeListener(ObjectTreeListener listener) {
        this.myListeners.remove(listener);
    }

    private void fireRegistered(Object object) {
        for (ObjectTreeListener each : this.myListeners) {
            each.objectRegistered(object);
        }
    }

    void fireExecuted(Object object) {
        for (ObjectTreeListener each : this.myListeners) {
            each.objectExecuted(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size() {
        Object object = this.treeLock;
        synchronized (object) {
            return this.myObject2NodeMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <D extends Disposable> D findRegisteredObject(T parentDisposable, D object) {
        Object object2 = this.treeLock;
        synchronized (object2) {
            ObjectNode<T> parentNode = this.getNode(parentDisposable);
            if (parentNode == null) {
                return null;
            }
            return parentNode.findChildEqualTo(object);
        }
    }

    long getModification() {
        return this.myModification.get();
    }
}

