/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import org.jetbrains.annotations.NonNls;

public class StringUtilRt {
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return a == b || StringUtilRt.toUpperCase(a) == StringUtilRt.toUpperCase(b) || StringUtilRt.toLowerCase(a) == StringUtilRt.toLowerCase(b);
    }

    public static CharSequence toUpperCase(CharSequence s) {
        StringBuilder answer = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            char upcased = StringUtilRt.toUpperCase(c);
            if (answer == null && upcased != c) {
                answer = new StringBuilder(s.length());
                answer.append(s.subSequence(0, i));
            }
            if (answer == null) continue;
            answer.append(upcased);
        }
        return answer == null ? s : answer;
    }

    public static char toUpperCase(char a) {
        if (a < 'a') {
            return a;
        }
        if (a <= 'z') {
            return (char)(a + -32);
        }
        return Character.toUpperCase(a);
    }

    public static char toLowerCase(char a) {
        if (a < 'A' || a >= 'a' && a <= 'z') {
            return a;
        }
        if (a <= 'Z') {
            return (char)(a + 32);
        }
        return Character.toLowerCase(a);
    }

    public static String convertLineSeparators(String text) {
        return StringUtilRt.convertLineSeparators(text, false);
    }

    public static String convertLineSeparators(String text, boolean keepCarriageReturn) {
        return StringUtilRt.convertLineSeparators(text, "\n", null, keepCarriageReturn);
    }

    public static String convertLineSeparators(String text, String newSeparator) {
        return StringUtilRt.convertLineSeparators(text, newSeparator, null);
    }

    public static CharSequence convertLineSeparators(CharSequence text, String newSeparator) {
        return StringUtilRt.unifyLineSeparators(text, newSeparator, null, false);
    }

    public static String convertLineSeparators(String text, String newSeparator, int[] offsetsToKeep) {
        return StringUtilRt.convertLineSeparators(text, newSeparator, offsetsToKeep, false);
    }

    public static String convertLineSeparators(String text, String newSeparator, int[] offsetsToKeep, boolean keepCarriageReturn) {
        return ((Object)StringUtilRt.unifyLineSeparators(text, newSeparator, offsetsToKeep, keepCarriageReturn)).toString();
    }

    public static CharSequence unifyLineSeparators(CharSequence text) {
        return StringUtilRt.unifyLineSeparators(text, "\n", null, false);
    }

    public static CharSequence unifyLineSeparators(CharSequence text, String newSeparator, int[] offsetsToKeep, boolean keepCarriageReturn) {
        StringBuilder buffer = null;
        int intactLength = 0;
        boolean newSeparatorIsSlashN = "\n".equals(newSeparator);
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                if (!newSeparatorIsSlashN) {
                    if (buffer == null) {
                        buffer = new StringBuilder(text.length());
                        buffer.append(text, 0, intactLength);
                    }
                    buffer.append(newSeparator);
                    StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 1, newSeparator.length());
                    continue;
                }
                if (buffer == null) {
                    ++intactLength;
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (c == '\r') {
                boolean followedByLineFeed;
                boolean bl = followedByLineFeed = i < text.length() - 1 && text.charAt(i + 1) == '\n';
                if (!followedByLineFeed && keepCarriageReturn) {
                    if (buffer == null) {
                        ++intactLength;
                        continue;
                    }
                    buffer.append(c);
                    continue;
                }
                if (buffer == null) {
                    buffer = new StringBuilder(text.length());
                    buffer.append(text, 0, intactLength);
                }
                buffer.append(newSeparator);
                if (followedByLineFeed) {
                    ++i;
                    StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 2, newSeparator.length());
                    continue;
                }
                StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 1, newSeparator.length());
                continue;
            }
            if (buffer == null) {
                ++intactLength;
                continue;
            }
            buffer.append(c);
        }
        return buffer == null ? text : buffer;
    }

    private static void shiftOffsets(int[] offsets, int changeOffset, int oldLength, int newLength) {
        if (offsets == null) {
            return;
        }
        int shift = newLength - oldLength;
        if (shift == 0) {
            return;
        }
        for (int i = 0; i < offsets.length; ++i) {
            int offset = offsets[i];
            if (offset < changeOffset + oldLength) continue;
            int n = i;
            offsets[n] = offsets[n] + shift;
        }
    }

    public static int parseInt(String string, int defaultValue) {
        if (string == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static double parseDouble(String string, double defaultValue) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean parseBoolean(String string, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(string);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getShortName(Class aClass) {
        return StringUtilRt.getShortName(aClass.getName());
    }

    public static String getShortName(String fqName) {
        return StringUtilRt.getShortName(fqName, '.');
    }

    public static String getShortName(String fqName, char separator) {
        int lastPointIdx = fqName.lastIndexOf(separator);
        if (lastPointIdx >= 0) {
            return fqName.substring(lastPointIdx + 1);
        }
        return fqName;
    }

    public static boolean endsWithChar(CharSequence s, char suffix) {
        return s != null && s.length() != 0 && s.charAt(s.length() - 1) == suffix;
    }

    public static boolean startsWithIgnoreCase(@NonNls String str, @NonNls String prefix) {
        int prefixLength;
        int stringLength = str.length();
        return stringLength >= (prefixLength = prefix.length()) && str.regionMatches(true, 0, prefix, 0, prefixLength);
    }

    public static boolean endsWithIgnoreCase(@NonNls CharSequence text, @NonNls CharSequence suffix) {
        int l2;
        int l1 = text.length();
        if (l1 < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (StringUtilRt.charsEqualIgnoreCase(text.charAt(i), suffix.charAt(i + l2 - l1))) continue;
            return false;
        }
        return true;
    }

    public static int lastIndexOf(CharSequence s, char c, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }
}

