/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.CharArrayCharSequence;
import gnu.trove.Equality;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class ArrayUtil
extends ArrayUtilRt {
    public static final short[] EMPTY_SHORT_ARRAY = ArrayUtilRt.EMPTY_SHORT_ARRAY;
    public static final char[] EMPTY_CHAR_ARRAY = ArrayUtilRt.EMPTY_CHAR_ARRAY;
    public static final byte[] EMPTY_BYTE_ARRAY = ArrayUtilRt.EMPTY_BYTE_ARRAY;
    public static final int[] EMPTY_INT_ARRAY = ArrayUtilRt.EMPTY_INT_ARRAY;
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = ArrayUtilRt.EMPTY_BOOLEAN_ARRAY;
    public static final Object[] EMPTY_OBJECT_ARRAY = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY = ArrayUtilRt.EMPTY_STRING_ARRAY;
    public static final Class[] EMPTY_CLASS_ARRAY = ArrayUtilRt.EMPTY_CLASS_ARRAY;
    public static final long[] EMPTY_LONG_ARRAY = ArrayUtilRt.EMPTY_LONG_ARRAY;
    public static final Collection[] EMPTY_COLLECTION_ARRAY = ArrayUtilRt.EMPTY_COLLECTION_ARRAY;
    public static final File[] EMPTY_FILE_ARRAY = ArrayUtilRt.EMPTY_FILE_ARRAY;
    public static final Runnable[] EMPTY_RUNNABLE_ARRAY = ArrayUtilRt.EMPTY_RUNNABLE_ARRAY;
    public static final CharSequence EMPTY_CHAR_SEQUENCE = new CharArrayCharSequence(EMPTY_CHAR_ARRAY);
    public static final ArrayFactory<String> STRING_ARRAY_FACTORY = new ArrayFactory<String>(){

        public String[] create(int count) {
            return ArrayUtil.newStringArray(count);
        }
    };
    public static final ArrayFactory<Object> OBJECT_ARRAY_FACTORY = new ArrayFactory<Object>(){

        @Override
        public Object[] create(int count) {
            return ArrayUtil.newObjectArray(count);
        }
    };

    private ArrayUtil() {
    }

    public static byte[] realloc(byte[] array, int newSize) {
        if (newSize == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            return array;
        }
        byte[] result = new byte[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        return result;
    }

    public static boolean[] realloc(boolean[] array, int newSize) {
        if (newSize == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            return array;
        }
        boolean[] result = new boolean[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        return result;
    }

    public static int[] realloc(int[] array, int newSize) {
        if (newSize == 0) {
            return EMPTY_INT_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            return array;
        }
        int[] result = new int[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        return result;
    }

    public static <T> T[] realloc(T[] array, int newSize, ArrayFactory<T> factory) {
        int oldSize = array.length;
        if (oldSize == newSize) {
            return array;
        }
        T[] result = factory.create(newSize);
        if (newSize == 0) {
            return result;
        }
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        return result;
    }

    public static int[] append(int[] array, int value) {
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        return array;
    }

    public static <T> T[] insert(T[] array, int index, T value) {
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, array.length - index);
        return result;
    }

    public static int[] insert(int[] array, int index, int value) {
        int[] result = new int[array.length + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, array.length - index);
        return result;
    }

    public static byte[] append(byte[] array, byte value) {
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        return array;
    }

    public static boolean[] append(boolean[] array, boolean value) {
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        return array;
    }

    public static char[] realloc(char[] array, int newSize) {
        if (newSize == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            return array;
        }
        char[] result = new char[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        return result;
    }

    public static <T> T[] toObjectArray(Collection<T> collection, Class<T> aClass) {
        Object[] array = (Object[])Array.newInstance(aClass, collection.size());
        return collection.toArray(array);
    }

    public static <T> T[] toObjectArray(Class<T> aClass, Object ... source) {
        Object[] array = (Object[])Array.newInstance(aClass, source.length);
        System.arraycopy(source, 0, array, 0, array.length);
        return array;
    }

    public static Object[] toObjectArray(Collection<?> collection) {
        if (collection.isEmpty()) {
            return EMPTY_OBJECT_ARRAY;
        }
        return collection.toArray(new Object[collection.size()]);
    }

    public static int[] toIntArray(Collection<Integer> list) {
        int[] ret = ArrayUtil.newIntArray(list.size());
        int i = 0;
        for (Integer e : list) {
            ret[i++] = e;
        }
        return ret;
    }

    public static <T> T[] mergeArrays(T[] a1, T[] a2) {
        Class<?> class2;
        if (a1.length == 0) {
            return a2;
        }
        if (a2.length == 0) {
            return a1;
        }
        Class<?> class1 = a1.getClass().getComponentType();
        Class<?> aClass = class1.isAssignableFrom(class2 = a2.getClass().getComponentType()) ? class1 : class2;
        Object[] result = (Object[])Array.newInstance(aClass, a1.length + a2.length);
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }

    public static <T> T[] mergeCollections(Collection<? extends T> c1, Collection<? extends T> c2, ArrayFactory<T> factory) {
        T[] res = factory.create(c1.size() + c2.size());
        int i = 0;
        for (T t : c1) {
            res[i++] = t;
        }
        for (T t : c2) {
            res[i++] = t;
        }
        return res;
    }

    public static <T> T[] mergeArrays(T[] a1, T[] a2, ArrayFactory<T> factory) {
        if (a1.length == 0) {
            return a2;
        }
        if (a2.length == 0) {
            return a1;
        }
        T[] result = factory.create(a1.length + a2.length);
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }

    public static String[] mergeArrays(String[] a1, String ... a2) {
        return ArrayUtil.mergeArrays(a1, a2, STRING_ARRAY_FACTORY);
    }

    public static int[] mergeArrays(int[] a1, int[] a2) {
        if (a1.length == 0) {
            return a2;
        }
        if (a2.length == 0) {
            return a1;
        }
        int[] result = new int[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }

    public static byte[] mergeArrays(byte[] a1, byte[] a2) {
        if (a1.length == 0) {
            return a2;
        }
        if (a2.length == 0) {
            return a1;
        }
        byte[] result = new byte[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }

    public static <T> T[] mergeArrayAndCollection(T[] array, Collection<T> collection, ArrayFactory<T> factory) {
        T[] array2;
        if (collection.isEmpty()) {
            return array;
        }
        try {
            array2 = collection.toArray(factory.create(collection.size()));
        }
        catch (ArrayStoreException e) {
            throw new RuntimeException("Bad elements in collection: " + collection, e);
        }
        if (array.length == 0) {
            return array2;
        }
        T[] result = factory.create(array.length + collection.size());
        System.arraycopy(array, 0, result, 0, array.length);
        System.arraycopy(array2, 0, result, array.length, array2.length);
        return result;
    }

    public static <T> T[] append(T[] src, T element) {
        return ArrayUtil.append(src, element, src.getClass().getComponentType());
    }

    public static <T> T[] prepend(T element, T[] array) {
        return ArrayUtil.prepend(element, array, array.getClass().getComponentType());
    }

    public static <T> T[] prepend(T element, T[] array, Class<T> type) {
        int length = array.length;
        Object[] result = (Object[])Array.newInstance(type, length + 1);
        System.arraycopy(array, 0, result, 1, length);
        result[0] = element;
        return result;
    }

    public static byte[] prepend(byte element, byte[] array) {
        int length = array.length;
        byte[] result = new byte[length + 1];
        result[0] = element;
        System.arraycopy(array, 0, result, 1, length);
        return result;
    }

    public static <T> T[] append(T[] src, T element, ArrayFactory<T> factory) {
        int length = src.length;
        T[] result = factory.create(length + 1);
        System.arraycopy(src, 0, result, 0, length);
        result[length] = element;
        return result;
    }

    public static <T> T[] append(T[] src, T element, Class<T> componentType) {
        int length = src.length;
        Object[] result = (Object[])Array.newInstance(componentType, length + 1);
        System.arraycopy(src, 0, result, 0, length);
        result[length] = element;
        return result;
    }

    public static <T> T[] remove(T[] src, int idx) {
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        Object[] result = (Object[])Array.newInstance(src.getClass().getComponentType(), length - 1);
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        return result;
    }

    public static <T> T[] remove(T[] src, int idx, ArrayFactory<T> factory) {
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        T[] result = factory.create(length - 1);
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        return result;
    }

    public static <T> T[] remove(T[] src, T element) {
        int idx = ArrayUtil.find(src, element);
        if (idx == -1) {
            return src;
        }
        return ArrayUtil.remove(src, idx);
    }

    public static <T> T[] remove(T[] src, T element, ArrayFactory<T> factory) {
        int idx = ArrayUtil.find(src, element);
        if (idx == -1) {
            return src;
        }
        return ArrayUtil.remove(src, idx, factory);
    }

    public static int[] remove(int[] src, int idx) {
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        int[] result = ArrayUtil.newIntArray(src.length - 1);
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        return result;
    }

    public static short[] remove(short[] src, int idx) {
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        short[] result = src.length == 1 ? EMPTY_SHORT_ARRAY : new short[src.length - 1];
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        return result;
    }

    public static int find(int[] src, int obj) {
        return ArrayUtil.indexOf(src, obj);
    }

    public static <T> int find(T[] src, T obj) {
        return ArrayUtilRt.find(src, obj);
    }

    public static boolean startsWith(byte[] array, byte[] prefix) {
        if (array == prefix) {
            return true;
        }
        int length = prefix.length;
        if (array.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean startsWith(E[] array, E[] subArray) {
        if (array == subArray) {
            return true;
        }
        int length = subArray.length;
        if (array.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Comparing.equal(array[i], subArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(byte[] array, int start, byte[] subArray) {
        int length = subArray.length;
        if (array.length - start < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array[start + i] == subArray[i]) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equals(T[] a1, T[] a2, Equality<? super T> comparator) {
        if (a1 == a2) {
            return true;
        }
        int length = a2.length;
        if (a1.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (comparator.equals(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equals(T[] a1, T[] a2, Comparator<? super T> comparator) {
        if (a1 == a2) {
            return true;
        }
        int length = a2.length;
        if (a1.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (comparator.compare(a1[i], a2[i]) == 0) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] reverseArray(T[] array) {
        Object[] newArray = (Object[])array.clone();
        for (int i = 0; i < array.length; ++i) {
            newArray[array.length - i - 1] = array[i];
        }
        return newArray;
    }

    public static int[] reverseArray(int[] array) {
        int[] newArray = (int[])array.clone();
        for (int i = 0; i < array.length; ++i) {
            newArray[array.length - i - 1] = array[i];
        }
        return newArray;
    }

    public static void reverse(char[] array) {
        for (int i = 0; i < array.length; ++i) {
            ArrayUtil.swap(array, array.length - i - 1, i);
        }
    }

    public static int lexicographicCompare(String[] obj1, String[] obj2) {
        for (int i = 0; i < Math.max(obj1.length, obj2.length); ++i) {
            String o2;
            String o1 = i < obj1.length ? obj1[i] : null;
            String string = o2 = i < obj2.length ? obj2[i] : null;
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int res = o1.compareToIgnoreCase(o2);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static <T> int lexicographicCompare(T[] obj1, T[] obj2) {
        for (int i = 0; i < Math.max(obj1.length, obj2.length); ++i) {
            Object o2;
            Object o1 = i < obj1.length ? obj1[i] : null;
            Object t = o2 = i < obj2.length ? (Object)obj2[i] : null;
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int res = ((Comparable)o1).compareTo(o2);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static <T> void swap(T[] array, int i1, int i2) {
        T t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static void swap(int[] array, int i1, int i2) {
        int t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static void swap(boolean[] array, int i1, int i2) {
        boolean t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static void swap(char[] array, int i1, int i2) {
        char t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static <T> void rotateLeft(T[] array, int i1, int i2) {
        T t = array[i1];
        System.arraycopy(array, i1 + 1, array, i1, i2 - i1);
        array[i2] = t;
    }

    public static <T> void rotateRight(T[] array, int i1, int i2) {
        T t = array[i2];
        System.arraycopy(array, i1, array, i1 + 1, i2 - i1);
        array[i1] = t;
    }

    public static int indexOf(Object[] objects, Object object) {
        return ArrayUtil.indexOf(objects, object, 0, objects.length);
    }

    public static int indexOf(Object[] objects, Object object, int start, int end) {
        if (object == null) {
            for (int i = start; i < end; ++i) {
                if (objects[i] != null) continue;
                return i;
            }
        } else {
            for (int i = start; i < end; ++i) {
                if (!object.equals(objects[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int indexOf(List<T> objects, T object, Equality<T> comparator) {
        for (int i = 0; i < objects.size(); ++i) {
            if (!comparator.equals(objects.get(i), object)) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(List<T> objects, T object, Comparator<T> comparator) {
        for (int i = 0; i < objects.size(); ++i) {
            if (comparator.compare(objects.get(i), object) != 0) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(T[] objects, T object, Equality<T> comparator) {
        for (int i = 0; i < objects.length; ++i) {
            if (!comparator.equals(objects[i], object)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] ints, int value) {
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(short[] ints, short value) {
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] src, T obj) {
        for (int i = src.length - 1; i >= 0; --i) {
            T o = src[i];
            if (!(o == null ? obj == null : o.equals(obj))) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] src, T obj, Equality<? super T> comparator) {
        for (int i = src.length - 1; i >= 0; --i) {
            T o = src[i];
            if (!comparator.equals(obj, o)) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(List<T> src, T obj, Equality<? super T> comparator) {
        for (int i = src.size() - 1; i >= 0; --i) {
            T o = src.get(i);
            if (!comparator.equals(obj, o)) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(Object o, Object ... objects) {
        return ArrayUtil.indexOf(objects, o) >= 0;
    }

    public static boolean contains(String s, String ... strings) {
        if (s == null) {
            for (String str : strings) {
                if (str != null) continue;
                return true;
            }
        } else {
            for (String str : strings) {
                if (!s.equals(str)) continue;
                return true;
            }
        }
        return false;
    }

    public static int[] newIntArray(int count) {
        return count == 0 ? EMPTY_INT_ARRAY : new int[count];
    }

    public static long[] newLongArray(int count) {
        return count == 0 ? EMPTY_LONG_ARRAY : new long[count];
    }

    public static String[] newStringArray(int count) {
        return count == 0 ? EMPTY_STRING_ARRAY : new String[count];
    }

    public static Object[] newObjectArray(int count) {
        return count == 0 ? EMPTY_OBJECT_ARRAY : new Object[count];
    }

    public static <E> E[] ensureExactSize(int count, E[] sample) {
        if (count == sample.length) {
            return sample;
        }
        Object[] array = (Object[])Array.newInstance(sample.getClass().getComponentType(), count);
        return array;
    }

    public static <T> T getFirstElement(T[] array) {
        return array != null && array.length > 0 ? (T)array[0] : null;
    }

    public static <T> T getLastElement(T[] array) {
        return array != null && array.length > 0 ? (T)array[array.length - 1] : null;
    }

    public static String[] toStringArray(Collection<String> collection) {
        return ArrayUtilRt.toStringArray(collection);
    }

    public static <T> void copy(Collection<? extends T> src, T[] dst, int dstOffset) {
        int i = dstOffset;
        for (T t : src) {
            dst[i++] = t;
        }
    }

    public static <T> T[] stripTrailingNulls(T[] array) {
        return array.length != 0 && array[array.length - 1] == null ? Arrays.copyOf(array, ArrayUtil.trailingNullsIndex(array)) : array;
    }

    private static <T> int trailingNullsIndex(T[] array) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] == null) continue;
            return i + 1;
        }
        return 0;
    }
}

