/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static Throwable getRootCause(Throwable e) {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    public static <T> T findCause(Throwable e, Class<T> klass) {
        while (e != null && !klass.isInstance(e)) {
            e = e.getCause();
        }
        return (T)e;
    }

    public static boolean causedBy(Throwable e, Class klass) {
        return ExceptionUtil.findCause(e, klass) != null;
    }

    public static Throwable makeStackTraceRelative(Throwable th, Throwable relativeTo) {
        StackTraceElement[] trace = th.getStackTrace();
        StackTraceElement[] rootTrace = relativeTo.getStackTrace();
        int len = Math.min(trace.length, rootTrace.length);
        for (int i = 0; i < len; ++i) {
            if (trace[trace.length - i - 1].equals(rootTrace[rootTrace.length - i - 1])) continue;
            int newDepth = trace.length - i;
            th.setStackTrace(Arrays.asList(trace).subList(0, newDepth).toArray(new StackTraceElement[newDepth]));
            break;
        }
        return th;
    }

    public static String getThrowableText(Throwable aThrowable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        aThrowable.printStackTrace(writer);
        return stringWriter.getBuffer().toString();
    }

    public static String getThrowableText(Throwable aThrowable, @NonNls String stackFrameSkipPattern) {
        String prefix = "\tat ";
        String prefixProxy = "\tat $Proxy";
        String prefixRemoteUtil = "\tat com.intellij.execution.rmi.RemoteUtil";
        final String skipPattern = "\tat " + stackFrameSkipPattern;
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)stringWriter){
            boolean skipping;
            {
                super(x0);
                this.skipping = false;
            }

            @Override
            public void println(String x) {
                boolean curSkipping = this.skipping;
                if (x != null) {
                    if (!this.skipping && x.startsWith(skipPattern)) {
                        curSkipping = true;
                    } else if (this.skipping && !x.startsWith("\tat ")) {
                        curSkipping = false;
                    }
                    if (curSkipping && !this.skipping) {
                        super.println("\tin " + ExceptionUtil.stripPackage(x, skipPattern.length()));
                    }
                    this.skipping = curSkipping;
                    if (this.skipping) {
                        this.skipping = !x.startsWith("\tat com.intellij.execution.rmi.RemoteUtil");
                        return;
                    }
                    if (x.startsWith("\tat $Proxy")) {
                        return;
                    }
                    super.println(x);
                }
            }
        };
        aThrowable.printStackTrace(writer);
        return stringWriter.getBuffer().toString();
    }

    private static String stripPackage(String x, int offset) {
        int idx = offset;
        while (idx > 0 && idx < x.length() && !Character.isUpperCase(x.charAt(idx))) {
            idx = x.indexOf(46, idx) + 1;
        }
        return x.substring(Math.max(idx, offset));
    }

    public static String getUserStackTrace(Throwable aThrowable, Logger logger) {
        String result = ExceptionUtil.getThrowableText(aThrowable, "com.intellij.");
        if (!result.contains("\n\tat")) {
            logger.error(aThrowable);
        }
        return result;
    }

    public static String getMessage(Throwable e) {
        String result = e.getMessage();
        String exceptionPattern = "Exception: ";
        String errorPattern = "Error: ";
        while ((result == null || result.contains("Exception: ") || result.contains("Error: ")) && e.getCause() != null) {
            e = e.getCause();
            result = e.getMessage();
        }
        if (result != null) {
            result = ExceptionUtil.extractMessage(result, "Exception: ");
            result = ExceptionUtil.extractMessage(result, "Error: ");
        }
        return result;
    }

    private static String extractMessage(String result, String errorPattern) {
        if (result.lastIndexOf(errorPattern) >= 0) {
            result = result.substring(result.lastIndexOf(errorPattern) + errorPattern.length());
        }
        return result;
    }

    public static void rethrowUnchecked(Throwable t) {
        if (t != null) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
        }
    }

    public static void rethrowAll(Throwable t) throws Exception {
        if (t != null) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw (Exception)t;
        }
    }
}

