/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;

@Deprecated
public class ImageLoader
implements Serializable {
    public static final Component ourComponent = new Component(){};
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ImageLoader");

    private static boolean waitForImage(Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediatracker = new MediaTracker(ourComponent);
        mediatracker.addImage(image, 1);
        try {
            mediatracker.waitForID(1, 5000L);
        }
        catch (InterruptedException ex) {
            LOG.info(ex);
        }
        return !mediatracker.isErrorID(1);
    }

    public static Image loadFromUrl(URL url) {
        return ImageLoader.loadFromUrl(url, true);
    }

    public static Image loadFromUrl(URL url, boolean allowFloatScaling) {
        for (Pair<String, Integer> each : ImageLoader.getFileNames(url.toString())) {
            try {
                float scale;
                Image image = ImageLoader.loadFromStream(URLUtil.openStream(new URL((String)each.first)), (Integer)each.second);
                float f = allowFloatScaling ? JBUI.scale(1.0f) : (scale = JBUI.scale(1.0f) > 1.5f ? 2.0f : 1.0f);
                if (image != null && JBUI.isHiDPI()) {
                    image = ((String)each.first).contains("@2x") ? ImageLoader.scaleImage(image, (double)(scale / 2.0f)) : ImageLoader.scaleImage(image, (double)scale);
                }
                return image;
            }
            catch (IOException ignore) {
            }
        }
        return null;
    }

    private static Image scaleImage(Image image, double scale) {
        return ImageLoader.scaleImage(ImageUtil.toBufferedImage(image), scale);
    }

    private static Image scaleImage(BufferedImage source, double scale) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        int destWidth = Math.max(1, (int)(scale * (double)sourceWidth));
        int destHeight = Math.max(1, (int)(scale * (double)sourceHeight));
        int imageType = source.getType();
        if (imageType == 0) {
            imageType = 2;
        }
        BufferedImage scaled = new BufferedImage(destWidth, destHeight, imageType);
        Graphics2D g2 = scaled.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setColor(new Color(0, true));
        g2.fillRect(0, 0, destWidth, destHeight);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawImage(source, 0, 0, destWidth, destHeight, 0, 0, sourceWidth, sourceHeight, null);
        g2.dispose();
        return scaled;
    }

    public static Image loadFromUrl(URL url, boolean dark, boolean retina) {
        for (Pair<String, Integer> each : ImageLoader.getFileNames(url.toString(), dark, retina || JBUI.isHiDPI())) {
            try {
                return ImageLoader.loadFromStream(URLUtil.openStream(new URL((String)each.first)), (Integer)each.second);
            }
            catch (IOException ignore) {
            }
        }
        return null;
    }

    public static Image loadFromResource(@NonNls String s) {
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        if (callerClass == null) {
            return null;
        }
        return ImageLoader.loadFromResource(s, callerClass);
    }

    public static Image loadFromResource(@NonNls String path, Class aClass) {
        for (Pair<String, Integer> each : ImageLoader.getFileNames(path)) {
            Image image;
            InputStream stream = aClass.getResourceAsStream((String)each.first);
            if (stream == null || (image = ImageLoader.loadFromStream(stream, (Integer)each.second)) == null) continue;
            return image;
        }
        return null;
    }

    public static List<Pair<String, Integer>> getFileNames(String file) {
        return ImageLoader.getFileNames(file, UIUtil.isUnderDarcula(), UIUtil.isRetina() || JBUI.isHiDPI());
    }

    public static List<Pair<String, Integer>> getFileNames(String file, boolean dark, boolean retina) {
        if (retina || dark) {
            ArrayList<Pair<String, Integer>> answer = new ArrayList<Pair<String, Integer>>(4);
            String name = FileUtil.getNameWithoutExtension(file);
            String ext = FileUtilRt.getExtension(file);
            if (dark && retina) {
                answer.add(Pair.create(name + "@2x_dark." + ext, 2));
            }
            if (dark) {
                answer.add(Pair.create(name + "_dark." + ext, 1));
            }
            if (retina) {
                answer.add(Pair.create(name + "@2x." + ext, 2));
            }
            answer.add(Pair.create(file, 1));
            return answer;
        }
        return Collections.singletonList(Pair.create(file, 1));
    }

    public static Image loadFromStream(InputStream inputStream) {
        return ImageLoader.loadFromStream(inputStream, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image loadFromStream(InputStream inputStream, int scale) {
        if (scale <= 0) {
            throw new IllegalArgumentException("Scale must 1 or more");
        }
        try {
            BufferExposingByteArrayOutputStream outputStream = new BufferExposingByteArrayOutputStream();
            try {
                int n;
                byte[] buffer = new byte[1024];
                while ((n = inputStream.read(buffer)) >= 0) {
                    outputStream.write(buffer, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(outputStream.getInternalBuffer(), 0, outputStream.size());
            ImageLoader.waitForImage(image);
            if (UIUtil.isRetina() && scale > 1) {
                image = RetinaImage.createFrom(image, scale, ourComponent);
            }
            return image;
        }
        catch (Exception ex) {
            LOG.error(ex);
            return null;
        }
    }

    public static boolean isGoodSize(Icon icon) {
        return IconLoader.isGoodSize(icon);
    }
}

