/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MemoryDumpHelper {
    private static final String HOT_SPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final Object ourMXBean;
    private static final Method ourDumpHeap;

    public static boolean memoryDumpAvailable() {
        try {
            return ourMXBean != null;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    public static synchronized void captureMemoryDump(String dumpPath) throws Exception {
        ourDumpHeap.invoke(ourMXBean, dumpPath, true);
    }

    public static Object getHotspotMBean() {
        return ourMXBean;
    }

    static {
        Method dumpHeap;
        Object mxBean;
        try {
            final Class<?> hotSpotMxBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            mxBean = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                    Set<ObjectName> s = server.queryNames(new ObjectName(MemoryDumpHelper.HOT_SPOT_BEAN_NAME), null);
                    Iterator<ObjectName> itr = s.iterator();
                    if (itr.hasNext()) {
                        ObjectName name = itr.next();
                        return ManagementFactory.newPlatformMXBeanProxy(server, name.toString(), hotSpotMxBeanClass);
                    }
                    return null;
                }
            });
            dumpHeap = mxBean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
        }
        catch (Throwable t) {
            Logger.getInstance("#com.intellij.util.MemoryDumpHelper").info(t.getMessage());
            mxBean = null;
            dumpHeap = null;
        }
        ourMXBean = mxBean;
        ourDumpHeap = dumpHeap;
    }
}

