/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

public class PathUtilRt {
    public static String getFileName(String path) {
        if (path.isEmpty()) {
            return "";
        }
        char c = path.charAt(path.length() - 1);
        int end = c == '/' || c == '\\' ? path.length() - 1 : path.length();
        int start = Math.max(path.lastIndexOf(47, end - 1), path.lastIndexOf(92, end - 1)) + 1;
        return path.substring(start, end);
    }

    public static String getParentPath(String path) {
        if (path.length() == 0) {
            return "";
        }
        int end = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        if (end == path.length() - 1) {
            end = Math.max(path.lastIndexOf(47, end - 1), path.lastIndexOf(92, end - 1));
        }
        return end == -1 ? "" : path.substring(0, end);
    }

    public static String suggestFileName(String text) {
        return PathUtilRt.suggestFileName(text, false, false);
    }

    public static String suggestFileName(String text, boolean allowDots, boolean allowSpaces) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!PathUtilRt.isValidFileNameChar(c) || !allowDots && c == '.' || !allowSpaces && Character.isWhitespace(c)) {
                result.append('_');
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static boolean isValidFileName(String fileName) {
        if (fileName.length() == 0 || fileName.equals(".") || fileName.equals("..")) {
            return false;
        }
        for (int i = 0; i < fileName.length(); ++i) {
            if (PathUtilRt.isValidFileNameChar(fileName.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidFileNameChar(char c) {
        return c != '/' && c != '\\' && c != '\t' && c != '\n' && c != '\r' && c != ':' && c != ';' && c != '*' && c != '?' && c != '\"' && c != '\'' && c != '<' && c != '>';
    }
}

