/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import sun.reflect.ConstructorAccessor;

public class ReflectionUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ReflectionUtil");
    private static final Method acquireConstructorAccessorMethod = ReflectionUtil.getDeclaredMethod(Constructor.class, "acquireConstructorAccessor", new Class[0]);
    private static final Method getConstructorAccessorMethod = ReflectionUtil.getDeclaredMethod(Constructor.class, "getConstructorAccessor", new Class[0]);

    private ReflectionUtil() {
    }

    public static Type resolveVariable(TypeVariable variable, Class classType) {
        return ReflectionUtil.resolveVariable(variable, classType, true);
    }

    public static Type resolveVariable(TypeVariable variable, Class classType, boolean resolveInInterfacesOnly) {
        Class<?> aClass = ReflectionUtil.getRawType(classType);
        int index = ArrayUtilRt.find(aClass.getTypeParameters(), variable);
        if (index >= 0) {
            return variable;
        }
        Class<?>[] classes = aClass.getInterfaces();
        Type[] genericInterfaces = aClass.getGenericInterfaces();
        for (int i = 0; i <= classes.length; ++i) {
            Type type;
            Class<?> anInterface;
            if (i < classes.length) {
                anInterface = classes[i];
            } else {
                anInterface = aClass.getSuperclass();
                if (resolveInInterfacesOnly || anInterface == null) continue;
            }
            Type resolved = ReflectionUtil.resolveVariable(variable, anInterface);
            if (resolved instanceof Class || resolved instanceof ParameterizedType) {
                return resolved;
            }
            if (!(resolved instanceof TypeVariable)) continue;
            TypeVariable typeVariable = (TypeVariable)resolved;
            index = ArrayUtilRt.find(anInterface.getTypeParameters(), typeVariable);
            if (index < 0) {
                LOG.error("Cannot resolve type variable:\ntypeVariable = " + typeVariable + "\n" + "genericDeclaration = " + ReflectionUtil.declarationToString(typeVariable.getGenericDeclaration()) + "\n" + "searching in " + ReflectionUtil.declarationToString(anInterface));
            }
            Type type2 = type = i < genericInterfaces.length ? genericInterfaces[i] : aClass.getGenericSuperclass();
            if (type instanceof Class) {
                return Object.class;
            }
            if (type instanceof ParameterizedType) {
                return ReflectionUtil.getActualTypeArguments((ParameterizedType)type)[index];
            }
            throw new AssertionError((Object)("Invalid type: " + type));
        }
        return null;
    }

    public static String declarationToString(GenericDeclaration anInterface) {
        return anInterface.toString() + Arrays.asList(anInterface.getTypeParameters()) + " loaded by " + ((Class)anInterface).getClassLoader();
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionUtil.getRawType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ReflectionUtil.getRawType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        assert (false) : type;
        return null;
    }

    public static Type[] getActualTypeArguments(ParameterizedType parameterizedType) {
        return parameterizedType.getActualTypeArguments();
    }

    public static Class<?> substituteGenericType(Type genericType, Type classType) {
        if (genericType instanceof TypeVariable) {
            int index;
            Class<?> aClass = ReflectionUtil.getRawType(classType);
            Type type = ReflectionUtil.resolveVariable((TypeVariable)genericType, aClass);
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable && classType instanceof ParameterizedType && (index = ArrayUtilRt.find(aClass.getTypeParameters(), type)) >= 0) {
                return ReflectionUtil.getRawType(ReflectionUtil.getActualTypeArguments((ParameterizedType)classType)[index]);
            }
        } else {
            return ReflectionUtil.getRawType(genericType);
        }
        return null;
    }

    public static List<Field> collectFields(Class clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        ReflectionUtil.collectFields(clazz, result);
        return result;
    }

    public static Field findField(Class clazz, final Class type, final String name) throws NoSuchFieldException {
        Field result = ReflectionUtil.processFields(clazz, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return name.equals(field.getName()) && (type == null || field.getType().equals(type));
            }
        });
        if (result != null) {
            return result;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type);
    }

    public static Field findAssignableField(Class<?> clazz, final Class<?> fieldType, final String fieldName) throws NoSuchFieldException {
        Field result = ReflectionUtil.processFields(clazz, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return fieldName.equals(field.getName()) && (fieldType == null || fieldType.isAssignableFrom(field.getType()));
            }
        });
        if (result != null) {
            return result;
        }
        throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + fieldName + " fieldType: " + fieldType);
    }

    private static void collectFields(Class clazz, List<Field> result) {
        Class<?>[] interfaces;
        Field[] fields = clazz.getDeclaredFields();
        result.addAll(Arrays.asList(fields));
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            ReflectionUtil.collectFields(superClass, result);
        }
        for (Class<?> each : interfaces = clazz.getInterfaces()) {
            ReflectionUtil.collectFields(each, result);
        }
    }

    private static Field processFields(Class clazz, Condition<Field> checker) {
        Class<?>[] interfaces;
        Field result;
        for (Field field : clazz.getDeclaredFields()) {
            if (!checker.value(field)) continue;
            field.setAccessible(true);
            return field;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && (result = ReflectionUtil.processFields(superClass, checker)) != null) {
            return result;
        }
        for (Class<?> each : interfaces = clazz.getInterfaces()) {
            Field result2 = ReflectionUtil.processFields(each, checker);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public static void resetField(Class clazz, Class type, String name) {
        try {
            ReflectionUtil.resetField(null, ReflectionUtil.findField(clazz, type, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(Object object, Class type, String name) {
        try {
            ReflectionUtil.resetField(object, ReflectionUtil.findField(object.getClass(), type, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(Object object, String name) {
        try {
            ReflectionUtil.resetField(object, ReflectionUtil.findField(object.getClass(), null, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(Object object, Field field) {
        field.setAccessible(true);
        Class<?> type = field.getType();
        try {
            if (type.isPrimitive()) {
                if (Boolean.TYPE.equals(type)) {
                    field.set(object, Boolean.FALSE);
                } else if (Integer.TYPE.equals(type)) {
                    field.set(object, 0);
                } else if (Double.TYPE.equals(type)) {
                    field.set(object, 0.0);
                } else if (Float.TYPE.equals(type)) {
                    field.set(object, Float.valueOf(0.0f));
                }
            } else {
                field.set(object, null);
            }
        }
        catch (IllegalAccessException e) {
            LOG.info(e);
        }
    }

    public static Method findMethod(Collection<Method> methods, @NonNls String name, Class ... parameters) {
        for (Method method : methods) {
            if (!name.equals(method.getName()) || !Arrays.equals(parameters, method.getParameterTypes())) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    public static Method getMethod(Class aClass, @NonNls String name, Class ... parameters) {
        return ReflectionUtil.findMethod(ReflectionUtil.getClassPublicMethods(aClass, false), name, parameters);
    }

    public static Method getDeclaredMethod(Class aClass, @NonNls String name, Class ... parameters) {
        return ReflectionUtil.findMethod(ReflectionUtil.getClassDeclaredMethods(aClass, false), name, parameters);
    }

    public static Field getDeclaredField(Class aClass, final @NonNls String name) {
        return ReflectionUtil.processFields(aClass, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return name.equals(field.getName());
            }
        });
    }

    public static List<Method> getClassPublicMethods(Class aClass) {
        return ReflectionUtil.getClassPublicMethods(aClass, false);
    }

    public static List<Method> getClassPublicMethods(Class aClass, boolean includeSynthetic) {
        Method[] methods = aClass.getMethods();
        return includeSynthetic ? Arrays.asList(methods) : ReflectionUtil.filterRealMethods(methods);
    }

    public static List<Method> getClassDeclaredMethods(Class aClass) {
        return ReflectionUtil.getClassDeclaredMethods(aClass, false);
    }

    public static List<Method> getClassDeclaredMethods(Class aClass, boolean includeSynthetic) {
        Method[] methods = aClass.getDeclaredMethods();
        return includeSynthetic ? Arrays.asList(methods) : ReflectionUtil.filterRealMethods(methods);
    }

    public static List<Field> getClassDeclaredFields(Class aClass) {
        Field[] fields = aClass.getDeclaredFields();
        return Arrays.asList(fields);
    }

    private static List<Method> filterRealMethods(Method[] methods) {
        ArrayList<Method> result = ContainerUtil.newArrayList();
        for (Method method : methods) {
            if (method.isSynthetic()) continue;
            result.add(method);
        }
        return result;
    }

    public static Class getMethodDeclaringClass(Class<?> instanceClass, @NonNls String methodName, Class ... parameters) {
        Method method = ReflectionUtil.getMethod(instanceClass, methodName, parameters);
        return method == null ? null : method.getDeclaringClass();
    }

    public static <T> T getField(Class objectClass, Object object, Class<T> fieldType, @NonNls String fieldName) {
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            return (T)field.get(object);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static <T> boolean setField(Class objectClass, Object object, Class<T> fieldType, @NonNls String fieldName, T value) {
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            field.set(object, value);
            return true;
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return false;
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return false;
        }
    }

    public static Type resolveVariableInHierarchy(TypeVariable variable, Class aClass) {
        Type type;
        Class current = aClass;
        while ((type = ReflectionUtil.resolveVariable(variable, current, false)) == null) {
            if ((current = current.getSuperclass()) != null) continue;
            return null;
        }
        if (type instanceof TypeVariable) {
            return ReflectionUtil.resolveVariableInHierarchy((TypeVariable)type, aClass);
        }
        return type;
    }

    public static <T> Constructor<T> getDefaultConstructor(Class<T> aClass) {
        try {
            Constructor<T> constructor = aClass.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No default constructor in " + aClass, e);
        }
    }

    public static ConstructorAccessor getConstructorAccessor(Constructor constructor) {
        constructor.setAccessible(true);
        try {
            acquireConstructorAccessorMethod.invoke((Object)constructor, new Object[0]);
            return (ConstructorAccessor)getConstructorAccessorMethod.invoke((Object)constructor, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T createInstanceViaConstructorAccessor(ConstructorAccessor constructorAccessor, Object ... arguments) {
        try {
            return (T)constructorAccessor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T createInstanceViaConstructorAccessor(ConstructorAccessor constructorAccessor) {
        try {
            return (T)constructorAccessor.newInstance(ArrayUtil.EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> aClass, Class ... parameterTypes) {
        try {
            Constructor<T> constructor = aClass.getDeclaredConstructor(parameterTypes);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException e) {
                return aClass.newInstance();
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T createInstance(Constructor<T> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void resetThreadLocals() {
        ReflectionUtil.resetField(Thread.currentThread(), null, "threadLocals");
    }

    public static Class getGrandCallerClass() {
        int stackFrameCount = 3;
        Class callerClass = ReflectionUtil.findCallerClass(stackFrameCount);
        while (callerClass != null && callerClass.getClassLoader() == null) {
            callerClass = ReflectionUtil.findCallerClass(++stackFrameCount);
        }
        if (callerClass == null) {
            callerClass = ReflectionUtil.findCallerClass(2);
        }
        return callerClass;
    }

    public static void copyFields(Field[] fields, Object from, Object to) {
        ReflectionUtil.copyFields(fields, from, to, null);
    }

    public static boolean copyFields(Field[] fields, Object from, Object to, DifferenceFilter diffFilter) {
        HashSet<Field> sourceFields = new HashSet<Field>(Arrays.asList(from.getClass().getFields()));
        boolean valuesChanged = false;
        for (Field field : fields) {
            if (!sourceFields.contains(field) || !ReflectionUtil.isPublic(field) || ReflectionUtil.isFinal(field)) continue;
            try {
                if (diffFilter != null && !diffFilter.isAccept(field)) continue;
                ReflectionUtil.copyFieldValue(from, to, field);
                valuesChanged = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return valuesChanged;
    }

    public static void copyFieldValue(Object from, Object to, Field field) throws IllegalAccessException {
        Class<?> fieldType = field.getType();
        if (!fieldType.isPrimitive() && !fieldType.equals(String.class)) {
            throw new RuntimeException("Field '" + field.getName() + "' not copied: unsupported type: " + field.getType());
        }
        field.set(to, field.get(from));
    }

    private static boolean isPublic(Field field) {
        return (field.getModifiers() & 1) != 0;
    }

    private static boolean isFinal(Field field) {
        return (field.getModifiers() & 0x10) != 0;
    }

    public static Class findCallerClass(int framesToSkip) {
        try {
            Class[] stack = MySecurityManager.INSTANCE.getStack();
            int indexFromTop = 1 + framesToSkip;
            return stack.length > indexFromTop ? stack[indexFromTop] : null;
        }
        catch (Exception e) {
            LOG.warn(e);
            return null;
        }
    }

    public static boolean isAssignable(Class<?> ancestor, Class<?> descendant) {
        return ancestor == descendant || ancestor.isAssignableFrom(descendant);
    }

    private static class MySecurityManager
    extends SecurityManager {
        private static final MySecurityManager INSTANCE = new MySecurityManager();

        private MySecurityManager() {
        }

        public Class[] getStack() {
            return this.getClassContext();
        }
    }
}

