/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.util.Timed;

public abstract class TimedComputable<T>
extends Timed<T> {
    private int myAcquireCount = 0;

    public TimedComputable(Disposable parentDisposable) {
        super(parentDisposable);
    }

    public synchronized T acquire() {
        ++this.myAccessCount;
        ++this.myAcquireCount;
        if (this.myT == null) {
            this.myT = this.calc();
        }
        this.poll();
        return (T)this.myT;
    }

    protected synchronized T getIfCached() {
        return (T)this.myT;
    }

    public synchronized void release() {
        --this.myAcquireCount;
        assert (this.myAcquireCount >= 0);
    }

    @Override
    public synchronized void dispose() {
        assert (this.myAcquireCount == 0);
        super.dispose();
    }

    @Override
    protected synchronized boolean isLocked() {
        return this.myAcquireCount != 0;
    }

    protected abstract T calc();
}

