/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentHashSet<K>
implements Set<K> {
    private final ConcurrentMap<K, Boolean> map;

    public ConcurrentHashSet(int initialCapacity) {
        this.map = ContainerUtil.newConcurrentMap(initialCapacity);
    }

    public ConcurrentHashSet() {
        this.map = ContainerUtil.newConcurrentMap();
    }

    public ConcurrentHashSet(TObjectHashingStrategy<K> hashingStrategy) {
        this.map = ContainerUtil.newConcurrentMap(hashingStrategy);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<K> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public boolean add(K o) {
        return this.map.putIfAbsent(o, Boolean.TRUE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.keySet().remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.map.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        boolean ret = false;
        for (K o : c) {
            ret |= this.add(o);
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.map.keySet().retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.map.keySet().removeAll(c);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.keySet().toString();
    }
}

