/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

abstract class ConcurrentRefValueHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, ValueReference<K, V>> myMap;
    protected final ReferenceQueue<V> myQueue = new ReferenceQueue();

    public ConcurrentRefValueHashMap(Map<K, V> map) {
        this();
        this.putAll(map);
    }

    public ConcurrentRefValueHashMap() {
        this.myMap = ContainerUtil.newConcurrentMap();
    }

    public ConcurrentRefValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.myMap = ContainerUtil.newConcurrentMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    public ConcurrentRefValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, TObjectHashingStrategy<K> hashingStrategy) {
        this.myMap = ContainerUtil.newConcurrentMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    boolean processQueue() {
        ValueReference ref;
        boolean processed = false;
        while ((ref = (ValueReference)((Object)this.myQueue.poll())) != null) {
            this.myMap.remove(ref.getKey(), ref);
            processed = true;
        }
        return processed;
    }

    @Override
    public V get(Object key) {
        ValueReference ref = (ValueReference)this.myMap.get(key);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        ValueReference<K, V> oldRef = this.myMap.put(key, this.createValueReference(key, value));
        return oldRef != null ? (V)oldRef.get() : null;
    }

    protected abstract ValueReference<K, V> createValueReference(K var1, V var2);

    @Override
    public V putIfAbsent(K key, V value) {
        V oldVal;
        block2: {
            ValueReference<K, V> oldRef;
            ValueReference<K, V> newRef = this.createValueReference(key, value);
            do {
                this.processQueue();
                oldRef = this.myMap.putIfAbsent(key, newRef);
                if (oldRef == null) {
                    return null;
                }
                oldVal = oldRef.get();
                if (oldVal != null) break block2;
            } while (!this.myMap.replace(key, oldRef, newRef));
            return null;
        }
        return oldVal;
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.processQueue();
        return this.myMap.remove(key, this.createValueReference(key, value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.processQueue();
        return this.myMap.replace(key, this.createValueReference(key, oldValue), this.createValueReference(key, newValue));
    }

    @Override
    public V replace(K key, V value) {
        this.processQueue();
        ValueReference<K, V> ref = this.myMap.replace(key, this.createValueReference(key, value));
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        ValueReference ref = (ValueReference)this.myMap.remove(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.processQueue();
        for (K k : t.keySet()) {
            V v = t.get(k);
            if (v == null) continue;
            this.put(k, v);
        }
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return this.myMap.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList result = new ArrayList();
        Collection refs = this.myMap.values();
        for (ValueReference ref : refs) {
            Object value = ref.get();
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<K> keys = this.keySet();
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (final K key : keys) {
            final V value = this.get(key);
            if (value == null) continue;
            entries.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(V value2) {
                    throw new UnsupportedOperationException("setValue is not implemented");
                }
            });
        }
        return entries;
    }

    public String toString() {
        String s = "map size:" + this.size() + " [";
        for (Object k : this.myMap.keySet()) {
            V v = this.get(k);
            s = s + "'" + k + "': '" + v + "', ";
        }
        s = s + "] ";
        return s;
    }

    int underlyingMapSize() {
        return this.myMap.size();
    }

    protected static interface ValueReference<K, V> {
        public K getKey();

        public V get();
    }
}

