/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class ConcurrentRefValueIntObjectHashMap<V>
implements ConcurrentIntObjectMap<V> {
    private final ConcurrentIntObjectMap<IntReference<V>> myMap = ContainerUtil.createConcurrentIntObjectMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    ConcurrentRefValueIntObjectHashMap() {
    }

    protected abstract IntReference<V> createReference(int var1, V var2, ReferenceQueue<V> var3);

    private void processQueue() {
        IntReference ref;
        while ((ref = (IntReference)((Object)this.myQueue.poll())) != null) {
            int key = ref.getKey();
            this.myMap.remove(key, ref);
        }
        return;
    }

    @Override
    public V cacheOrGet(int key, V value) {
        IntReference<V> ref;
        boolean replaced;
        this.processQueue();
        IntReference<V> newRef = this.createReference(key, value, this.myQueue);
        do {
            if ((ref = this.myMap.putIfAbsent(key, newRef)) == null) {
                return value;
            }
            V old = ref.get();
            if (old == null) continue;
            return old;
        } while (!(replaced = this.myMap.replace(key, ref, newRef)));
        return value;
    }

    @Override
    public boolean remove(int key, V value) {
        this.processQueue();
        return this.myMap.remove(key, this.createReference(key, value, this.myQueue));
    }

    @Override
    public boolean replace(int key, V oldValue, V newValue) {
        this.processQueue();
        return this.myMap.replace(key, this.createReference(key, oldValue, this.myQueue), this.createReference(key, newValue, this.myQueue));
    }

    @Override
    public V put(int key, V value) {
        this.processQueue();
        IntReference<V> ref = this.myMap.put(key, this.createReference(key, value, this.myQueue));
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V get(int key) {
        IntReference<V> ref = this.myMap.get(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V remove(int key) {
        this.processQueue();
        IntReference<V> ref = this.myMap.remove(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public boolean containsKey(int key) {
        return this.myMap.containsKey(key);
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public int[] keys() {
        return this.myMap.keys();
    }

    @Override
    public Iterable<ConcurrentIntObjectMap.IntEntry<V>> entries() {
        final Iterator<ConcurrentIntObjectMap.IntEntry<IntReference<V>>> entryIterator = this.myMap.entries().iterator();
        return new Iterable<ConcurrentIntObjectMap.IntEntry<V>>(){

            @Override
            public Iterator<ConcurrentIntObjectMap.IntEntry<V>> iterator() {
                return new Iterator<ConcurrentIntObjectMap.IntEntry<V>>(){
                    ConcurrentIntObjectMap.IntEntry<V> next = this.nextAliveEntry();

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public ConcurrentIntObjectMap.IntEntry<V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ConcurrentIntObjectMap.IntEntry result = this.next;
                        this.next = this.nextAliveEntry();
                        return result;
                    }

                    private ConcurrentIntObjectMap.IntEntry<V> nextAliveEntry() {
                        while (entryIterator.hasNext()) {
                            ConcurrentIntObjectMap.IntEntry entry = (ConcurrentIntObjectMap.IntEntry)entryIterator.next();
                            final Object v = ((IntReference)entry.getValue()).get();
                            if (v == null) continue;
                            final int key = entry.getKey();
                            return new ConcurrentIntObjectMap.IntEntry<V>(){

                                @Override
                                public int getKey() {
                                    return key;
                                }

                                @Override
                                public V getValue() {
                                    return v;
                                }
                            };
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public Enumeration<V> elements() {
        final Enumeration<IntReference<V>> elementRefs = this.myMap.elements();
        return new Enumeration<V>(){
            V next = this.findNextRef();

            private V findNextRef() {
                while (elementRefs.hasMoreElements()) {
                    IntReference result = (IntReference)elementRefs.nextElement();
                    Object v = result.get();
                    if (v == null) continue;
                    return v;
                }
                return null;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next != null;
            }

            @Override
            public V nextElement() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object v = this.next;
                this.next = this.findNextRef();
                return v;
            }
        };
    }

    @Override
    public V putIfAbsent(int key, V value) {
        IntReference<V> prev = this.myMap.putIfAbsent(key, this.createReference(key, value, this.myQueue));
        return prev == null ? null : (V)prev.get();
    }

    @Override
    public Collection<V> values() {
        THashSet result = new THashSet();
        ContainerUtil.addAll(result, this.elements());
        return result;
    }

    @Override
    public boolean containsValue(V value) {
        for (ConcurrentIntObjectMap.IntEntry<IntReference<V>> entry : this.myMap.entries()) {
            if (!value.equals(entry.getValue().get())) continue;
            return true;
        }
        return false;
    }

    protected static interface IntReference<V> {
        public int getKey();

        public V get();
    }
}

