/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ConcurrentRefValueHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Map;

public final class ConcurrentSoftValueHashMap<K, V>
extends ConcurrentRefValueHashMap<K, V> {
    public ConcurrentSoftValueHashMap(Map<K, V> map) {
        super(map);
    }

    public ConcurrentSoftValueHashMap() {
    }

    public ConcurrentSoftValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        super(initialCapacity, loadFactor, concurrencyLevel);
    }

    public ConcurrentSoftValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, TObjectHashingStrategy<K> hashingStrategy) {
        super(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @Override
    protected ConcurrentRefValueHashMap.ValueReference<K, V> createValueReference(K key, V value) {
        return new MySoftReference(key, value, this.myQueue);
    }

    private static class MySoftReference<K, T>
    extends SoftReference<T>
    implements ConcurrentRefValueHashMap.ValueReference<K, T> {
        private final K key;

        private MySoftReference(K key, T referent, ReferenceQueue<T> q) {
            super(referent, q);
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcurrentRefValueHashMap.ValueReference that = (ConcurrentRefValueHashMap.ValueReference)o;
            return this.key.equals(that.getKey()) && Comparing.equal(this.get(), that.get());
        }

        public final int hashCode() {
            return this.key.hashCode();
        }
    }
}

