/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ConcurrentRefValueIntObjectHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

class ConcurrentWeakValueIntObjectHashMap<V>
extends ConcurrentRefValueIntObjectHashMap<V> {
    ConcurrentWeakValueIntObjectHashMap() {
    }

    @Override
    protected ConcurrentRefValueIntObjectHashMap.IntReference<V> createReference(int key, V value, ReferenceQueue<V> queue) {
        return new MyRef<V>(key, value, queue);
    }

    private static class MyRef<V>
    extends WeakReference<V>
    implements ConcurrentRefValueIntObjectHashMap.IntReference<V> {
        private final int hash;
        private final int key;

        MyRef(int key, V referent, ReferenceQueue<V> queue) {
            super(referent, queue);
            this.key = key;
            this.hash = referent.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            Object v = this.get();
            if (!(obj instanceof MyRef)) {
                return false;
            }
            MyRef other = (MyRef)obj;
            return other.hash == this.hash && this.key == other.getKey() && Comparing.equal(v, other.get());
        }

        @Override
        public int getKey() {
            return this.key;
        }
    }
}

