/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SingletonSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ConcurrentHashSet;
import com.intellij.util.containers.ConcurrentIntObjectHashMap;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ConcurrentLongObjectHashMap;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ConcurrentSoftHashMap;
import com.intellij.util.containers.ConcurrentSoftValueHashMap;
import com.intellij.util.containers.ConcurrentSoftValueIntObjectHashMap;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import com.intellij.util.containers.ConcurrentWeakValueIntObjectHashMap;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.EmptyIterable;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.LockFreeCopyOnWriteArrayList;
import com.intellij.util.containers.SequenceIterator;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ContainerUtil
extends ContainerUtilRt {
    private static final int INSERTION_SORT_THRESHOLD = 10;
    private static final int DEFAULT_CONCURRENCY_LEVEL = Math.min(16, Runtime.getRuntime().availableProcessors());
    private static final ConcurrentMapFactory V8_MAP_FACTORY = new ConcurrentMapFactory(){

        @Override
        public <T, V> ConcurrentMap<T, V> createMap() {
            return new ConcurrentHashMap();
        }

        @Override
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity) {
            return new ConcurrentHashMap(initialCapacity);
        }

        @Override
        public <T, V> ConcurrentMap<T, V> createMap(TObjectHashingStrategy<T> hashStrategy) {
            return new ConcurrentHashMap(hashStrategy);
        }

        @Override
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
            return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
        }

        @Override
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel, TObjectHashingStrategy<T> hashingStrategy) {
            return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
        }
    };
    private static final ConcurrentMapFactory PLATFORM_MAP_FACTORY = new ConcurrentMapFactory(){

        @Override
        public <T, V> ConcurrentMap<T, V> createMap() {
            return this.createMap(16, 0.75f, DEFAULT_CONCURRENCY_LEVEL);
        }

        @Override
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity) {
            return new java.util.concurrent.ConcurrentHashMap(initialCapacity);
        }

        @Override
        public <T, V> ConcurrentMap<T, V> createMap(TObjectHashingStrategy<T> hashingStrategy) {
            if (hashingStrategy != ContainerUtil.canonicalStrategy()) {
                throw new UnsupportedOperationException("Custom hashStrategy is not supported in java.util.concurrent.ConcurrentHashMap");
            }
            return this.createMap();
        }

        @Override
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
            return new java.util.concurrent.ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
        }

        @Override
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel, TObjectHashingStrategy<T> hashingStrategy) {
            if (hashingStrategy != ContainerUtil.canonicalStrategy()) {
                throw new UnsupportedOperationException("Custom hashStrategy is not supported in java.util.concurrent.ConcurrentHashMap");
            }
            return this.createMap(initialCapacity, loadFactor, concurrencyLevel);
        }
    };
    private static final ConcurrentMapFactory CHM_FACTORY = SystemInfo.isOracleJvm || SystemInfo.isSunJvm || SystemInfo.isAppleJvm || ContainerUtil.isAtLeastJava7() ? V8_MAP_FACTORY : PLATFORM_MAP_FACTORY;

    public static <T> T[] ar(T ... elements) {
        return elements;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return ContainerUtilRt.newHashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(Map<? extends K, ? extends V> map) {
        return ContainerUtilRt.newHashMap(map);
    }

    public static <K, V> Map<K, V> newHashMap(Pair<K, V> first, Pair<K, V> ... entries) {
        return ContainerUtilRt.newHashMap(first, entries);
    }

    public static <K, V> Map<K, V> newHashMap(List<K> keys, List<V> values) {
        return ContainerUtilRt.newHashMap(keys, values);
    }

    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        return ContainerUtilRt.newTreeMap();
    }

    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap(Map<K, V> map) {
        return ContainerUtilRt.newTreeMap(map);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return ContainerUtilRt.newLinkedHashMap();
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int capacity) {
        return ContainerUtilRt.newLinkedHashMap(capacity);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Map<K, V> map) {
        return ContainerUtilRt.newLinkedHashMap(map);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Pair<K, V> first, Pair<K, V> ... entries) {
        return ContainerUtilRt.newLinkedHashMap(first, entries);
    }

    public static <K, V> THashMap<K, V> newTroveMap() {
        return new THashMap();
    }

    public static <K, V> THashMap<K, V> newTroveMap(TObjectHashingStrategy<K> strategy) {
        return new THashMap(strategy);
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(Class<K> keyType) {
        return new EnumMap(keyType);
    }

    public static <T> TObjectHashingStrategy<T> canonicalStrategy() {
        return TObjectHashingStrategy.CANONICAL;
    }

    public static <T> TObjectHashingStrategy<T> identityStrategy() {
        return TObjectHashingStrategy.IDENTITY;
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        return new IdentityHashMap();
    }

    public static <T> LinkedList<T> newLinkedList() {
        return ContainerUtilRt.newLinkedList();
    }

    public static <T> LinkedList<T> newLinkedList(T ... elements) {
        return ContainerUtilRt.newLinkedList(elements);
    }

    public static <T> LinkedList<T> newLinkedList(Iterable<? extends T> elements) {
        return ContainerUtilRt.newLinkedList(elements);
    }

    public static <T> ArrayList<T> newArrayList() {
        return ContainerUtilRt.newArrayList();
    }

    public static <E> ArrayList<E> newArrayList(E ... array) {
        return ContainerUtilRt.newArrayList(array);
    }

    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> iterable) {
        return ContainerUtilRt.newArrayList(iterable);
    }

    public static <T> ArrayList<T> newArrayListWithExpectedSize(int size) {
        return ContainerUtilRt.newArrayListWithCapacity(size);
    }

    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        return ContainerUtilRt.newArrayListWithCapacity(size);
    }

    public static <T> List<T> newArrayList(final T[] elements, final int start, final int end) {
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        return new AbstractList<T>(){
            private final int size;
            {
                this.size = end - start;
            }

            @Override
            public T get(int index) {
                if (index < 0 || index >= this.size) {
                    throw new IndexOutOfBoundsException("index:" + index + " size:" + this.size);
                }
                return elements[start + index];
            }

            @Override
            public int size() {
                return this.size;
            }
        };
    }

    public static <T> List<T> newUnmodifiableList(List<? extends T> originalList) {
        int size = originalList.size();
        if (size == 0) {
            return ContainerUtil.emptyList();
        }
        if (size == 1) {
            return Collections.singletonList(originalList.get(0));
        }
        return Collections.unmodifiableList(ContainerUtil.newArrayList(originalList));
    }

    public static <T> List<T> newSmartList() {
        return new SmartList();
    }

    public static <T> List<T> newSmartList(T element) {
        return new SmartList<T>(element);
    }

    public static <T> List<T> newSmartList(T ... elements) {
        return new SmartList<T>(elements);
    }

    public static <T> HashSet<T> newHashSet() {
        return ContainerUtilRt.newHashSet();
    }

    public static <T> HashSet<T> newHashSet(int initialCapacity) {
        return ContainerUtilRt.newHashSet(initialCapacity);
    }

    public static <T> HashSet<T> newHashSet(T ... elements) {
        return ContainerUtilRt.newHashSet(elements);
    }

    public static <T> HashSet<T> newHashSet(Iterable<? extends T> iterable) {
        return ContainerUtilRt.newHashSet(iterable);
    }

    public static <T> HashSet<T> newHashSet(Iterator<? extends T> iterator) {
        return ContainerUtilRt.newHashSet(iterator);
    }

    public static <T> Set<T> newHashOrEmptySet(Iterable<? extends T> iterable) {
        boolean empty = iterable == null || iterable instanceof Collection && ((Collection)iterable).isEmpty();
        return empty ? Collections.emptySet() : ContainerUtilRt.newHashSet(iterable);
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        return ContainerUtilRt.newLinkedHashSet();
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet(Iterable<? extends T> elements) {
        return ContainerUtilRt.newLinkedHashSet(elements);
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        return ContainerUtilRt.newLinkedHashSet(elements);
    }

    public static <T> THashSet<T> newTroveSet() {
        return new THashSet();
    }

    public static <T> THashSet<T> newTroveSet(TObjectHashingStrategy<T> strategy) {
        return new THashSet(strategy);
    }

    public static <T> THashSet<T> newTroveSet(T ... elements) {
        return ContainerUtil.newTroveSet(Arrays.asList(elements));
    }

    public static <T> THashSet<T> newTroveSet(TObjectHashingStrategy<T> strategy, T ... elements) {
        return new THashSet(Arrays.asList(elements), strategy);
    }

    public static <T> THashSet<T> newTroveSet(TObjectHashingStrategy<T> strategy, Collection<T> elements) {
        return new THashSet(elements, strategy);
    }

    public static <T> THashSet<T> newTroveSet(Collection<T> elements) {
        return new THashSet(elements);
    }

    /*
     * Exception decompiling
     */
    public static <K> THashSet<K> newIdentityTroveSet() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static <K> THashSet<K> newIdentityTroveSet(int initialCapacity) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static <K> THashSet<K> newIdentityTroveSet(Collection<K> collection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static <K, V> THashMap<K, V> newIdentityTroveMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> TreeSet<T> newTreeSet() {
        return ContainerUtilRt.newTreeSet();
    }

    public static <T> TreeSet<T> newTreeSet(Iterable<? extends T> elements) {
        return ContainerUtilRt.newTreeSet(elements);
    }

    public static <T> TreeSet<T> newTreeSet(T ... elements) {
        return ContainerUtilRt.newTreeSet(elements);
    }

    public static <T> TreeSet<T> newTreeSet(Comparator<? super T> comparator) {
        return ContainerUtilRt.newTreeSet(comparator);
    }

    public static <T> Set<T> newConcurrentSet() {
        return new ConcurrentHashSet();
    }

    public static <T> Set<T> newConcurrentSet(TObjectHashingStrategy<T> hashStrategy) {
        return new ConcurrentHashSet<T>(hashStrategy);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return CHM_FACTORY.createMap();
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(TObjectHashingStrategy<K> hashStrategy) {
        return CHM_FACTORY.createMap(hashStrategy);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity) {
        return CHM_FACTORY.createMap(initialCapacity);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel, TObjectHashingStrategy<K> hashStrategy) {
        return CHM_FACTORY.createMap(initialCapacity, loadFactor, concurrencyLevel, hashStrategy);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return CHM_FACTORY.createMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    public static <E> List<E> reverse(final List<E> elements) {
        if (elements.isEmpty()) {
            return ContainerUtilRt.emptyList();
        }
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return elements.get(elements.size() - 1 - index);
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
    }

    public static <K, V> Map<K, V> union(Map<? extends K, ? extends V> map, Map<? extends K, ? extends V> map2) {
        THashMap result = new THashMap(map.size() + map2.size());
        result.putAll(map);
        result.putAll(map2);
        return result;
    }

    public static <T> Set<T> union(Set<T> set, Set<T> set2) {
        THashSet result = new THashSet(set.size() + set2.size());
        result.addAll(set);
        result.addAll(set2);
        return result;
    }

    public static <E> Set<E> immutableSet(E ... elements) {
        return Collections.unmodifiableSet(new THashSet(Arrays.asList(elements)));
    }

    public static <E> ImmutableList<E> immutableList(E ... array) {
        return new ImmutableListBackedByArray(array);
    }

    public static <E> ImmutableList<E> immutableList(List<E> list) {
        return new ImmutableListBackedByList(list);
    }

    public static <K, V> ImmutableMapBuilder<K, V> immutableMapBuilder() {
        return new ImmutableMapBuilder();
    }

    public static <K, V> Map<K, V> intersection(Map<K, V> map1, Map<K, V> map2) {
        HashMap res = ContainerUtil.newHashMap();
        HashSet<K> keys = ContainerUtil.newHashSet();
        keys.addAll(map1.keySet());
        keys.addAll(map2.keySet());
        for (Object k : keys) {
            V v2;
            V v1 = map1.get(k);
            if (v1 != (v2 = map2.get(k)) && (v1 == null || !v1.equals(v2))) continue;
            res.put(k, v1);
        }
        return res;
    }

    public static <K, V> Map<K, Couple<V>> diff(Map<K, V> map1, Map<K, V> map2) {
        HashMap res = ContainerUtil.newHashMap();
        HashSet<K> keys = ContainerUtil.newHashSet();
        keys.addAll(map1.keySet());
        keys.addAll(map2.keySet());
        for (Object k : keys) {
            V v2;
            V v1 = map1.get(k);
            if (v1 == (v2 = map2.get(k)) || v1 != null && v1.equals(v2)) continue;
            res.put(k, Couple.of(v1, v2));
        }
        return res;
    }

    public static <T> boolean processSortedListsInOrder(List<T> list1, List<T> list2, Comparator<? super T> comparator, boolean mergeEqualItems, Processor<T> processor) {
        int index1 = 0;
        int index2 = 0;
        while (index1 < list1.size() || index2 < list2.size()) {
            T e;
            if (index1 >= list1.size()) {
                e = list2.get(index2++);
            } else if (index2 >= list2.size()) {
                e = list1.get(index1++);
            } else {
                T element2;
                T element1 = list1.get(index1);
                int c = comparator.compare(element1, element2 = list2.get(index2));
                if (c <= 0) {
                    e = element1;
                    ++index1;
                } else {
                    e = element2;
                    ++index2;
                }
                if (c == 0 && !mergeEqualItems) {
                    if (!processor.process(e)) {
                        return false;
                    }
                    ++index2;
                    e = element2;
                }
            }
            if (processor.process(e)) continue;
            return false;
        }
        return true;
    }

    public static <T> List<T> mergeSortedLists(List<T> list1, List<T> list2, Comparator<? super T> comparator, boolean mergeEqualItems) {
        final ArrayList result = new ArrayList(list1.size() + list2.size());
        ContainerUtil.processSortedListsInOrder(list1, list2, comparator, mergeEqualItems, new Processor<T>(){

            @Override
            public boolean process(T t) {
                result.add(t);
                return true;
            }
        });
        return result;
    }

    public static <T> List<T> mergeSortedArrays(T[] list1, T[] list2, Comparator<? super T> comparator, boolean mergeEqualItems, Processor<? super T> filter) {
        int index1 = 0;
        int index2 = 0;
        ArrayList<T> result = new ArrayList<T>(list1.length + list2.length);
        while (index1 < list1.length || index2 < list2.length) {
            T t;
            if (index1 >= list1.length) {
                t = list2[index2++];
                if (filter != null && !filter.process(t)) continue;
                result.add(t);
                continue;
            }
            if (index2 >= list2.length) {
                t = list1[index1++];
                if (filter != null && !filter.process(t)) continue;
                result.add(t);
                continue;
            }
            T element1 = list1[index1];
            if (filter != null && !filter.process(element1)) {
                ++index1;
                continue;
            }
            T element2 = list2[index2];
            if (filter != null && !filter.process(element2)) {
                ++index2;
                continue;
            }
            int c = comparator.compare(element1, element2);
            if (c < 0) {
                result.add(element1);
                ++index1;
                continue;
            }
            if (c > 0) {
                result.add(element2);
                ++index2;
                continue;
            }
            result.add(element1);
            if (!mergeEqualItems) {
                result.add(element2);
            }
            ++index1;
            ++index2;
        }
        return result;
    }

    public static <T> List<T> subList(List<T> list, int from) {
        return list.subList(from, list.size());
    }

    public static <T> void addAll(Collection<T> collection, Iterable<? extends T> appendix) {
        ContainerUtil.addAll(collection, appendix.iterator());
    }

    public static <T> void addAll(Collection<T> collection, Iterator<? extends T> iterator) {
        while (iterator.hasNext()) {
            T o = iterator.next();
            collection.add(o);
        }
    }

    public static <T> void addAllNotNull(Collection<T> collection, Iterable<? extends T> elements) {
        ContainerUtil.addAllNotNull(collection, elements.iterator());
    }

    public static <T> void addAllNotNull(Collection<T> collection, Iterator<? extends T> elements) {
        while (elements.hasNext()) {
            T o = elements.next();
            if (o == null) continue;
            collection.add(o);
        }
    }

    public static <T> List<T> collect(Iterator<T> iterator) {
        if (!iterator.hasNext()) {
            return ContainerUtil.emptyList();
        }
        ArrayList list = new ArrayList();
        ContainerUtil.addAll(list, iterator);
        return list;
    }

    public static <T> Set<T> collectSet(Iterator<T> iterator) {
        if (!iterator.hasNext()) {
            return Collections.emptySet();
        }
        HashSet<T> hashSet = ContainerUtil.newHashSet();
        ContainerUtil.addAll(hashSet, iterator);
        return hashSet;
    }

    public static <K, V> Map<K, V> newMapFromKeys(Iterator<K> keys, Convertor<K, V> valueConvertor) {
        HashMap<K, V> map = ContainerUtil.newHashMap();
        while (keys.hasNext()) {
            K key = keys.next();
            map.put(key, valueConvertor.convert(key));
        }
        return map;
    }

    public static <K, V> Map<K, V> newMapFromValues(Iterator<V> values, Convertor<V, K> keyConvertor) {
        HashMap<K, V> map = ContainerUtil.newHashMap();
        while (values.hasNext()) {
            V value = values.next();
            map.put(keyConvertor.convert(value), value);
        }
        return map;
    }

    public static <K, V> Map<K, Set<V>> classify(Iterator<V> iterator, Convertor<V, K> keyConvertor) {
        LinkedHashMap<K, LinkedHashSet<V>> hashMap = new LinkedHashMap<K, LinkedHashSet<V>>();
        while (iterator.hasNext()) {
            V value = iterator.next();
            K key = keyConvertor.convert(value);
            LinkedHashSet<V> set = (LinkedHashSet<V>)hashMap.get(key);
            if (set == null) {
                set = new LinkedHashSet<V>();
                hashMap.put(key, set);
            }
            set.add(value);
        }
        return hashMap;
    }

    public static <T> Iterator<T> emptyIterator() {
        return EmptyIterator.getInstance();
    }

    public static <T> Iterable<T> emptyIterable() {
        return EmptyIterable.getInstance();
    }

    public static <T> T find(T[] array, Condition<T> condition) {
        for (T element : array) {
            if (!condition.value(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean process(Iterable<? extends T> iterable, Processor<T> processor) {
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(List<? extends T> list, Processor<T> processor) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T t = list.get(i);
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(T[] iterable, Processor<? super T> processor) {
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(Iterator<T> iterator, Processor<? super T> processor) {
        while (iterator.hasNext()) {
            if (processor.process(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <T, V extends T> V find(Iterable<V> iterable, Condition<T> condition) {
        return ContainerUtil.find(iterable.iterator(), condition);
    }

    public static <T> T find(Iterable<? extends T> iterable, final T equalTo) {
        return (T)ContainerUtil.find(iterable, new Condition<T>(){

            @Override
            public boolean value(T object) {
                return equalTo == object || equalTo.equals(object);
            }
        });
    }

    public static <T, V extends T> V find(Iterator<V> iterator, Condition<T> condition) {
        while (iterator.hasNext()) {
            V value = iterator.next();
            if (!condition.value(value)) continue;
            return value;
        }
        return null;
    }

    public static <T, KEY, VALUE> Map<KEY, VALUE> map2Map(T[] collection, Function<T, Pair<KEY, VALUE>> mapper) {
        return ContainerUtil.map2Map(Arrays.asList(collection), mapper);
    }

    public static <T, KEY, VALUE> Map<KEY, VALUE> map2Map(Collection<? extends T> collection, Function<T, Pair<KEY, VALUE>> mapper) {
        THashMap set = new THashMap(collection.size());
        for (T t : collection) {
            Pair<KEY, VALUE> pair = mapper.fun(t);
            set.put(pair.first, pair.second);
        }
        return set;
    }

    public static <T, KEY, VALUE> Map<KEY, VALUE> map2MapNotNull(T[] collection, Function<T, Pair<KEY, VALUE>> mapper) {
        return ContainerUtil.map2MapNotNull(Arrays.asList(collection), mapper);
    }

    public static <T, KEY, VALUE> Map<KEY, VALUE> map2MapNotNull(Collection<? extends T> collection, Function<T, Pair<KEY, VALUE>> mapper) {
        THashMap set = new THashMap(collection.size());
        for (T t : collection) {
            Pair<KEY, VALUE> pair = mapper.fun(t);
            if (pair == null) continue;
            set.put(pair.first, pair.second);
        }
        return set;
    }

    public static <KEY, VALUE> Map<KEY, VALUE> map2Map(Collection<Pair<KEY, VALUE>> collection) {
        THashMap result = new THashMap(collection.size());
        for (Pair<KEY, VALUE> pair : collection) {
            result.put(pair.first, pair.second);
        }
        return result;
    }

    public static <T> Object[] map2Array(T[] array, Function<T, Object> mapper) {
        return ContainerUtil.map2Array(array, Object.class, mapper);
    }

    public static <T> Object[] map2Array(Collection<T> array, Function<T, Object> mapper) {
        return ContainerUtil.map2Array(array, Object.class, mapper);
    }

    public static <T, V> V[] map2Array(T[] array, Class<? super V> aClass, Function<T, V> mapper) {
        return ContainerUtil.map2Array(Arrays.asList(array), aClass, mapper);
    }

    public static <T, V> V[] map2Array(Collection<? extends T> collection, Class<? super V> aClass, Function<T, V> mapper) {
        List<V> list = ContainerUtil.map2List(collection, mapper);
        Object[] array = (Object[])Array.newInstance(aClass, list.size());
        return list.toArray(array);
    }

    public static <T, V> V[] map2Array(Collection<? extends T> collection, V[] to, Function<T, V> mapper) {
        return ContainerUtil.map2List(collection, mapper).toArray(to);
    }

    public static <T> List<T> filter(T[] collection, Condition<? super T> condition) {
        return ContainerUtil.findAll(collection, condition);
    }

    public static int[] filter(int[] collection, TIntProcedure condition) {
        TIntArrayList result = new TIntArrayList();
        for (int t : collection) {
            if (!condition.execute(t)) continue;
            result.add(t);
        }
        return result.isEmpty() ? ArrayUtil.EMPTY_INT_ARRAY : result.toNativeArray();
    }

    public static <T> List<T> filter(Condition<? super T> condition, T ... collection) {
        return ContainerUtil.findAll(collection, condition);
    }

    public static <T> List<T> findAll(T[] collection, Condition<? super T> condition) {
        SmartList<T> result = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> filter(Collection<? extends T> collection, Condition<? super T> condition) {
        return ContainerUtil.findAll(collection, condition);
    }

    public static <K, V> Map<K, V> filter(Map<K, ? extends V> map, Condition<? super K> keyFilter) {
        HashMap<K, V> result = ContainerUtil.newHashMap();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!keyFilter.value(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <T> List<T> findAll(Collection<? extends T> collection, Condition<? super T> condition) {
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        SmartList<T> result = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> skipNulls(Collection<? extends T> collection) {
        return ContainerUtil.findAll(collection, Condition.NOT_NULL);
    }

    public static <T, V> List<V> findAll(T[] collection, Class<V> instanceOf) {
        return ContainerUtil.findAll(Arrays.asList(collection), instanceOf);
    }

    public static <T, V> V[] findAllAsArray(T[] collection, Class<V> instanceOf) {
        List<V> list = ContainerUtil.findAll(Arrays.asList(collection), instanceOf);
        Object[] array = (Object[])Array.newInstance(instanceOf, list.size());
        return list.toArray(array);
    }

    public static <T, V> V[] findAllAsArray(Collection<? extends T> collection, Class<V> instanceOf) {
        List<V> list = ContainerUtil.findAll(collection, instanceOf);
        Object[] array = (Object[])Array.newInstance(instanceOf, list.size());
        return list.toArray(array);
    }

    public static <T> T[] findAllAsArray(T[] collection, Condition<? super T> instanceOf) {
        List<Object> list = ContainerUtil.findAll(collection, instanceOf);
        Object[] array = (Object[])Array.newInstance(collection.getClass().getComponentType(), list.size());
        return list.toArray(array);
    }

    public static <T, V> List<V> findAll(Collection<? extends T> collection, Class<V> instanceOf) {
        SmartList<T> result = new SmartList<T>();
        for (T t : collection) {
            if (!instanceOf.isInstance(t)) continue;
            T v = t;
            result.add(v);
        }
        return result;
    }

    public static <T> void removeDuplicates(Collection<T> collection) {
        HashSet<T> collected = ContainerUtil.newHashSet();
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!collected.contains(t)) {
                collected.add(t);
                continue;
            }
            iterator.remove();
        }
    }

    public static Map<String, String> stringMap(String ... keyValues) {
        HashMap<String, String> result = ContainerUtil.newHashMap();
        for (int i = 0; i < keyValues.length - 1; i += 2) {
            result.put(keyValues[i], keyValues[i + 1]);
        }
        return result;
    }

    public static <T> Iterator<T> iterate(T[] arrays) {
        return Arrays.asList(arrays).iterator();
    }

    public static <T> Iterator<T> iterate(final Enumeration<T> enumeration) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterable<T> iterate(T[] arrays, Condition<? super T> condition) {
        return ContainerUtil.iterate(Arrays.asList(arrays), condition);
    }

    public static <T> Iterable<T> iterate(final Collection<? extends T> collection, final Condition<? super T> condition) {
        if (collection.isEmpty()) {
            return ContainerUtil.emptyIterable();
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<? extends T> impl;
                    T next;
                    {
                        this.impl = collection.iterator();
                        this.next = this.findNext();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public T next() {
                        Object result = this.next;
                        this.next = this.findNext();
                        return result;
                    }

                    private T findNext() {
                        while (this.impl.hasNext()) {
                            Object each = this.impl.next();
                            if (!condition.value(each)) continue;
                            return each;
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> iterateBackward(final List<? extends T> list) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    ListIterator<? extends T> it;
                    {
                        this.it = list.listIterator(list.size());
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasPrevious();
                    }

                    @Override
                    public T next() {
                        return this.it.previous();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }
        };
    }

    public static <E> void swapElements(List<E> list, int index1, int index2) {
        E e1 = list.get(index1);
        E e2 = list.get(index2);
        list.set(index1, e2);
        list.set(index2, e1);
    }

    public static <T> List<T> collect(Iterator<?> iterator, FilteringIterator.InstanceOf<T> instanceOf) {
        List list = ContainerUtil.collect(FilteringIterator.create(iterator, instanceOf));
        return list;
    }

    public static <T> void addAll(Collection<T> collection, Enumeration<? extends T> enumeration) {
        while (enumeration.hasMoreElements()) {
            T element = enumeration.nextElement();
            collection.add(element);
        }
    }

    public static <T, A extends T, C extends Collection<T>> C addAll(C collection, A ... elements) {
        for (A element : elements) {
            collection.add(element);
        }
        return collection;
    }

    public static <T, A extends T, C extends Collection<T>> C addAllNotNull(C collection, A ... elements) {
        for (A element : elements) {
            if (element == null) continue;
            collection.add(element);
        }
        return collection;
    }

    public static <T> boolean removeAll(Collection<T> collection, T ... elements) {
        boolean modified = false;
        for (T element : elements) {
            modified |= collection.remove(element);
        }
        return modified;
    }

    public static <T> boolean retainAll(Collection<T> collection, Condition<? super T> condition) {
        boolean modified = false;
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (condition.value(next)) continue;
            iterator.remove();
            modified = true;
        }
        return modified;
    }

    public static <T, U extends T> U findInstance(Iterable<T> iterable, Class<U> aClass) {
        return ContainerUtil.findInstance(iterable.iterator(), aClass);
    }

    public static <T, U extends T> U findInstance(Iterator<T> iterator, Class<U> aClass) {
        T u = ContainerUtil.find(iterator, FilteringIterator.instanceOf(aClass));
        return (U)u;
    }

    public static <T, U extends T> U findInstance(T[] array, Class<U> aClass) {
        return ContainerUtil.findInstance(Arrays.asList(array), aClass);
    }

    public static <T, V> List<T> concat(V[] array, Function<V, Collection<? extends T>> fun) {
        return ContainerUtil.concat(Arrays.asList(array), fun);
    }

    public static <T> List<T> concat(Iterable<? extends Collection<T>> list) {
        ArrayList result = new ArrayList();
        for (Collection<T> ts : list) {
            result.addAll(ts);
        }
        return result.isEmpty() ? Collections.emptyList() : result;
    }

    @Deprecated
    public static <T> List<T> concat(boolean appendTail, List<? extends T> list, T ... values) {
        return appendTail ? ContainerUtil.concat(list, ContainerUtil.list(values)) : ContainerUtil.concat(ContainerUtil.list(values), list);
    }

    public static <T> List<T> append(List<? extends T> list, T ... values) {
        return ContainerUtil.concat(list, ContainerUtil.list(values));
    }

    public static <T> List<T> prepend(List<? extends T> list, T ... values) {
        return ContainerUtil.concat(ContainerUtil.list(values), list);
    }

    public static <T> List<T> concat(final List<? extends T> list1, final List<? extends T> list2) {
        if (list1.isEmpty() && list2.isEmpty()) {
            return Collections.emptyList();
        }
        if (list1.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list1;
        }
        final int size1 = list1.size();
        final int size = size1 + list2.size();
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index < size1) {
                    return list1.get(index);
                }
                return list2.get(index - size1);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public static <T> Iterable<T> concat(final Iterable<? extends T> ... iterables) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                Iterator[] iterators = new Iterator[iterables.length];
                for (int i = 0; i < iterables.length; ++i) {
                    Iterable iterable = iterables[i];
                    iterators[i] = iterable.iterator();
                }
                Iterator i = ContainerUtil.concatIterators(iterators);
                return i;
            }
        };
    }

    public static <T> Iterator<T> concatIterators(Iterator<T> ... iterators) {
        return new SequenceIterator<T>(iterators);
    }

    public static <T> Iterator<T> concatIterators(Collection<Iterator<T>> iterators) {
        return new SequenceIterator<T>(iterators);
    }

    public static <T> Iterable<T> concat(final T[] ... iterables) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                Iterator[] iterators = new Iterator[iterables.length];
                for (Object[] iterable : iterables) {
                    iterators[i] = Arrays.asList(iterable).iterator();
                }
                Iterator i = ContainerUtil.concatIterators(iterators);
                return i;
            }
        };
    }

    public static <T> List<T> concat(final List<? extends T> ... lists) {
        int size = 0;
        for (List<T> list : lists) {
            size += list.size();
        }
        if (size == 0) {
            return ContainerUtil.emptyList();
        }
        final int finalSize = size;
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index >= 0 && index < finalSize) {
                    int from = 0;
                    for (List each : lists) {
                        if (from <= index && index < from + each.size()) {
                            return each.get(index - from);
                        }
                        from += each.size();
                    }
                }
                throw new IndexOutOfBoundsException("index: " + index + "size: " + this.size());
            }

            @Override
            public int size() {
                return finalSize;
            }
        };
    }

    public static <T> List<T> concat(List<List<? extends T>> lists) {
        List[] array = lists.toArray(new List[lists.size()]);
        return ContainerUtil.concat(array);
    }

    public static <T, V> List<T> concat(Iterable<? extends V> list, Function<V, Collection<? extends T>> listGenerator) {
        ArrayList<T> result = new ArrayList<T>();
        for (V v : list) {
            result.addAll(listGenerator.fun(v));
        }
        return result.isEmpty() ? ContainerUtil.emptyList() : result;
    }

    public static <T> boolean intersects(Collection<? extends T> collection1, Collection<? extends T> collection2) {
        if (collection1.size() <= collection2.size()) {
            for (T t : collection1) {
                if (!collection2.contains(t)) continue;
                return true;
            }
        } else {
            for (T t : collection2) {
                if (!collection1.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> Collection<T> intersection(Collection<? extends T> collection1, Collection<? extends T> collection2) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : collection1) {
            if (!collection2.contains(t)) continue;
            result.add(t);
        }
        return result.isEmpty() ? ContainerUtil.emptyList() : result;
    }

    public static <T> T getFirstItem(Collection<T> items) {
        return ContainerUtil.getFirstItem(items, null);
    }

    public static <T> T getFirstItem(List<T> items) {
        return items == null || items.isEmpty() ? null : (T)items.get(0);
    }

    public static <T> T getFirstItem(Collection<T> items, T defaultResult) {
        return items == null || items.isEmpty() ? defaultResult : items.iterator().next();
    }

    public static <T> List<T> getFirstItems(List<T> items, int maxItems) {
        return items.subList(0, Math.min(maxItems, items.size()));
    }

    public static <T> T iterateAndGetLastItem(Iterable<T> items) {
        Iterator<T> itr = items.iterator();
        T res = null;
        while (itr.hasNext()) {
            res = itr.next();
        }
        return res;
    }

    public static <T, L extends List<T>> T getLastItem(L list, T def) {
        return ContainerUtil.isEmpty(list) ? def : list.get(list.size() - 1);
    }

    public static <T, L extends List<T>> T getLastItem(L list) {
        return ContainerUtil.getLastItem(list, null);
    }

    public static <T> Collection<T> subtract(Collection<T> from, Collection<T> what) {
        HashSet<T> set = ContainerUtil.newHashSet(from);
        set.removeAll(what);
        return set.isEmpty() ? ContainerUtil.emptyList() : set;
    }

    public static <T> T[] toArray(Collection<T> c, ArrayFactory<T> factory) {
        return c != null ? c.toArray(factory.create(c.size())) : factory.create(0);
    }

    public static <T> T[] toArray(Collection<? extends T> c1, Collection<? extends T> c2, ArrayFactory<T> factory) {
        return ArrayUtil.mergeCollections(c1, c2, factory);
    }

    public static <T> T[] mergeCollectionsToArray(Collection<? extends T> c1, Collection<? extends T> c2, ArrayFactory<T> factory) {
        return ArrayUtil.mergeCollections(c1, c2, factory);
    }

    public static <T extends Comparable<T>> void sort(List<T> list) {
        int size = list.size();
        if (size < 2) {
            return;
        }
        if (size == 2) {
            Comparable t1;
            Comparable t0 = (Comparable)list.get(0);
            if (t0.compareTo(t1 = (Comparable)list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    Comparable tj;
                    Comparable ti = (Comparable)list.get(i);
                    if (ti.compareTo(tj = (Comparable)list.get(j)) >= 0) continue;
                    list.set(i, tj);
                    list.set(j, ti);
                }
            }
        } else {
            Collections.sort(list);
        }
    }

    public static <T> void sort(List<T> list, Comparator<? super T> comparator) {
        int size = list.size();
        if (size < 2) {
            return;
        }
        if (size == 2) {
            T t1;
            T t0 = list.get(0);
            if (comparator.compare(t0, t1 = list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T tj;
                    T ti = list.get(i);
                    if (comparator.compare(ti, tj = list.get(j)) >= 0) continue;
                    list.set(i, tj);
                    list.set(j, ti);
                }
            }
        } else {
            Collections.sort(list, comparator);
        }
    }

    public static <T extends Comparable<T>> void sort(T[] a) {
        int size = a.length;
        if (size < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (t0.compareTo(t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = a[i];
                    T tj = a[j];
                    if (ti.compareTo(tj) >= 0) continue;
                    a[i] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a);
        }
    }

    public static <T> List<T> sorted(Collection<T> list, Comparator<T> comparator) {
        return ContainerUtil.sorted(list, comparator);
    }

    public static <T> List<T> sorted(Iterable<T> list, Comparator<T> comparator) {
        ArrayList<T> sorted = ContainerUtil.newArrayList(list);
        ContainerUtil.sort(sorted, comparator);
        return sorted;
    }

    public static <T extends Comparable<T>> List<T> sorted(Collection<T> list) {
        return ContainerUtil.sorted(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.compareTo(o2);
            }
        });
    }

    public static <T> void sort(T[] a, Comparator<T> comparator) {
        int size = a.length;
        if (size < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (comparator.compare(t0, t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = a[i];
                    T tj = a[j];
                    if (comparator.compare(ti, tj) >= 0) continue;
                    a[i] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a, comparator);
        }
    }

    public static <T, V> List<V> map(Iterable<? extends T> iterable, Function<T, V> mapping) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : iterable) {
            result.add(mapping.fun(t));
        }
        return result.isEmpty() ? ContainerUtil.emptyList() : result;
    }

    public static <T, V> List<V> map(Collection<? extends T> iterable, Function<T, V> mapping) {
        if (iterable.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<V> result = new ArrayList<V>(iterable.size());
        for (T t : iterable) {
            result.add(mapping.fun(t));
        }
        return result;
    }

    public static <T, V> List<V> mapNotNull(T[] array, Function<T, V> mapping) {
        return ContainerUtil.mapNotNull(Arrays.asList(array), mapping);
    }

    public static <T, V> V[] mapNotNull(T[] array, Function<T, V> mapping, V[] emptyArray) {
        ArrayList<V> result = new ArrayList<V>(array.length);
        for (T t : array) {
            V v = mapping.fun(t);
            if (v == null) continue;
            result.add(v);
        }
        if (result.isEmpty()) {
            assert (emptyArray.length == 0) : "You must pass an empty array";
            return emptyArray;
        }
        return result.toArray(emptyArray);
    }

    public static <T, V> List<V> mapNotNull(Iterable<? extends T> iterable, Function<T, V> mapping) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : iterable) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        return result.isEmpty() ? ContainerUtil.emptyList() : result;
    }

    public static <T, V> List<V> mapNotNull(Collection<? extends T> iterable, Function<T, V> mapping) {
        if (iterable.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(iterable.size());
        for (T t : iterable) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        return result.isEmpty() ? ContainerUtil.emptyList() : result;
    }

    public static <T> List<T> packNullables(T ... elements) {
        ArrayList<T> list = new ArrayList<T>();
        for (T element : elements) {
            ContainerUtil.addIfNotNull(element, list);
        }
        return list.isEmpty() ? ContainerUtil.emptyList() : list;
    }

    public static <T, V> List<V> map(T[] array, Function<T, V> mapping) {
        ArrayList<T> result = new ArrayList<T>(array.length);
        for (T t : array) {
            result.add(mapping.fun(t));
        }
        return result.isEmpty() ? ContainerUtil.emptyList() : result;
    }

    public static <T, V> V[] map(T[] arr, Function<T, V> mapping, V[] emptyArray) {
        if (arr.length == 0) {
            assert (emptyArray.length == 0) : "You must pass an empty array";
            return emptyArray;
        }
        ArrayList<V> result = new ArrayList<V>(arr.length);
        for (T t : arr) {
            result.add(mapping.fun(t));
        }
        return result.toArray(emptyArray);
    }

    public static <T> Set<T> set(T ... items) {
        return ContainerUtil.newHashSet(items);
    }

    public static <K, V> void putIfNotNull(K key, V value, Map<K, V> result) {
        if (value != null) {
            result.put(key, value);
        }
    }

    public static <T> void add(final T element, final Collection<T> result, Disposable parentDisposable) {
        if (result.add(element)) {
            Disposer.register(parentDisposable, new Disposable(){

                @Override
                public void dispose() {
                    result.remove(element);
                }
            });
        }
    }

    public static <T> List<T> createMaybeSingletonList(T element) {
        return element == null ? ContainerUtil.emptyList() : Collections.singletonList(element);
    }

    public static <T> Set<T> createMaybeSingletonSet(T element) {
        return element == null ? Collections.emptySet() : Collections.singleton(element);
    }

    public static <T, V> V getOrCreate(Map<T, V> result, T key, V defaultValue) {
        V value = result.get(key);
        if (value == null) {
            value = defaultValue;
            result.put(key, value);
        }
        return value;
    }

    public static <T, V> V getOrCreate(Map<T, V> result, T key, Factory<V> factory) {
        V value = result.get(key);
        if (value == null) {
            value = factory.create();
            result.put(key, value);
        }
        return value;
    }

    public static <T, V> V getOrElse(Map<T, V> result, T key, V defValue) {
        V value = result.get(key);
        return value == null ? defValue : value;
    }

    public static <T> boolean and(T[] iterable, Condition<T> condition) {
        return ContainerUtil.and(Arrays.asList(iterable), condition);
    }

    public static <T> boolean and(Iterable<T> iterable, Condition<T> condition) {
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean exists(T[] iterable, Condition<T> condition) {
        return ContainerUtil.or(Arrays.asList(iterable), condition);
    }

    public static <T> boolean exists(Iterable<T> iterable, Condition<T> condition) {
        return ContainerUtil.or(iterable, condition);
    }

    public static <T> boolean or(T[] iterable, Condition<T> condition) {
        return ContainerUtil.or(Arrays.asList(iterable), condition);
    }

    public static <T> boolean or(Iterable<T> iterable, Condition<T> condition) {
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> List<T> unfold(T t, NullableFunction<T, T> next) {
        if (t == null) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        while (t != null) {
            list.add(t);
            t = next.fun(t);
        }
        return list;
    }

    public static <T> List<T> dropTail(List<T> items) {
        return items.subList(0, items.size() - 1);
    }

    public static <T> List<T> list(T ... items) {
        return Arrays.asList(items);
    }

    public static <T> void quickSort(List<T> list, Comparator<? super T> comparator) {
        ContainerUtil.quickSort(list, comparator, 0, list.size());
    }

    private static <T> void quickSort(List<T> x, Comparator<? super T> comparator, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comparator.compare(x.get(j), x.get(j - 1)) < 0; --j) {
                    ContainerUtil.swapElements(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ContainerUtil.med3(x, comparator, l, l + s, l + 2 * s);
                m = ContainerUtil.med3(x, comparator, m - s, m, m + s);
                n = ContainerUtil.med3(x, comparator, n - 2 * s, n - s, n);
            }
            m = ContainerUtil.med3(x, comparator, l, m, n);
        }
        T v = x.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && comparator.compare(x.get(b), v) <= 0) {
                if (comparator.compare(x.get(b), v) == 0) {
                    ContainerUtil.swapElements(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(v, x.get(c)) <= 0) {
                if (comparator.compare(x.get(c), v) == 0) {
                    ContainerUtil.swapElements(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ContainerUtil.swapElements(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ContainerUtil.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ContainerUtil.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ContainerUtil.quickSort(x, comparator, off, s);
        }
        if ((s = d - c) > 1) {
            ContainerUtil.quickSort(x, comparator, n - s, s);
        }
    }

    private static <T> int med3(List<T> x, Comparator<? super T> comparator, int a, int b, int c) {
        return comparator.compare(x.get(a), x.get(b)) < 0 ? (comparator.compare(x.get(b), x.get(c)) < 0 ? b : (comparator.compare(x.get(a), x.get(c)) < 0 ? c : a)) : (comparator.compare(x.get(c), x.get(b)) < 0 ? b : (comparator.compare(x.get(c), x.get(a)) < 0 ? c : a));
    }

    private static <T> void vecswap(List<T> x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ContainerUtil.swapElements(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    public static void mergeSortedArrays(TIntArrayList x1, TIntArrayList y1, TIntArrayList x2, TIntArrayList y2) {
        TIntArrayList newX = new TIntArrayList();
        TIntArrayList newY = new TIntArrayList();
        int i = 0;
        int j = 0;
        while (i < x1.size() && j < x2.size()) {
            if (x1.get(i) < x2.get(j) || x1.get(i) == x2.get(j) && y1.get(i) < y2.get(j)) {
                newX.add(x1.get(i));
                newY.add(y1.get(i));
                ++i;
                continue;
            }
            if (x1.get(i) > x2.get(j) || x1.get(i) == x2.get(j) && y1.get(i) > y2.get(j)) {
                newX.add(x2.get(j));
                newY.add(y2.get(j));
                ++j;
                continue;
            }
            newX.add(x1.get(i));
            newY.add(y1.get(i));
            ++i;
            ++j;
        }
        while (i < x1.size()) {
            newX.add(x1.get(i));
            newY.add(y1.get(i));
            ++i;
        }
        while (j < x2.size()) {
            newX.add(x2.get(j));
            newY.add(y2.get(j));
            ++j;
        }
        x1.clear();
        y1.clear();
        x1.add(newX.toNativeArray());
        y1.add(newY.toNativeArray());
    }

    public static <T> Set<T> singleton(T o, TObjectHashingStrategy<T> strategy) {
        return new SingletonSet<T>(o, strategy);
    }

    public static <E> List<E> flatten(Collection<E>[] collections) {
        return ContainerUtil.flatten(Arrays.asList(collections));
    }

    public static <E> List<E> flatten(Iterable<? extends Collection<E>> collections) {
        ArrayList result = new ArrayList();
        for (Collection<E> list : collections) {
            result.addAll(list);
        }
        return result.isEmpty() ? ContainerUtil.emptyList() : result;
    }

    public static <E> List<E> flattenIterables(Iterable<? extends Iterable<E>> collections) {
        ArrayList result = new ArrayList();
        for (Iterable<E> list : collections) {
            for (E e : list) {
                result.add(e);
            }
        }
        return result.isEmpty() ? ContainerUtil.emptyList() : result;
    }

    public static <K, V> V[] convert(K[] from, V[] to, Function<K, V> fun) {
        if (to.length < from.length) {
            Object[] array = (Object[])Array.newInstance(to.getClass().getComponentType(), from.length);
            to = array;
        }
        for (int i = 0; i < from.length; ++i) {
            to[i] = fun.fun(from[i]);
        }
        return to;
    }

    public static <T> boolean containsIdentity(Iterable<T> list, T element) {
        for (T t : list) {
            if (t != element) continue;
            return true;
        }
        return false;
    }

    public static <T> int indexOfIdentity(List<T> list, T element) {
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            if (list.get(i) != element) continue;
            return i;
        }
        return -1;
    }

    public static <T> boolean equalsIdentity(List<T> list1, List<T> list2) {
        int listSize = list1.size();
        if (list2.size() != listSize) {
            return false;
        }
        for (int i = 0; i < listSize; ++i) {
            if (list1.get(i) == list2.get(i)) continue;
            return false;
        }
        return true;
    }

    public static <T> int indexOf(List<T> list, Condition<T> condition) {
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            T t = list.get(i);
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(List<T> list, Condition<T> condition) {
        for (int i = list.size() - 1; i >= 0; --i) {
            T t = list.get(i);
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    public static <T, U extends T> U findLastInstance(List<T> list, final Class<U> clazz) {
        int i = ContainerUtil.lastIndexOf(list, new Condition<T>(){

            @Override
            public boolean value(T t) {
                return clazz.isInstance(t);
            }
        });
        return i < 0 ? null : (U)list.get(i);
    }

    public static <T> int indexOf(List<T> list, final T object) {
        return ContainerUtil.indexOf(list, new Condition<T>(){

            @Override
            public boolean value(T t) {
                return t.equals(object);
            }
        });
    }

    public static <A, B> Map<B, A> reverseMap(Map<A, B> map) {
        HashMap<B, A> result = ContainerUtil.newHashMap();
        for (Map.Entry<A, B> entry : map.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    public static <T> boolean processRecursively(T root, PairProcessor<T, List<T>> processor) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(root);
        while (!list.isEmpty()) {
            Object o = list.removeFirst();
            if (processor.process(o, list)) continue;
            return false;
        }
        return true;
    }

    public static <T> List<T> trimToSize(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return list;
    }

    public static <T> Stack<T> newStack() {
        return ContainerUtilRt.newStack();
    }

    public static <T> Stack<T> newStack(Collection<T> initial) {
        return ContainerUtilRt.newStack(initial);
    }

    public static <T> Stack<T> newStack(T ... initial) {
        return ContainerUtilRt.newStack(initial);
    }

    public static <T> List<T> emptyList() {
        return ContainerUtilRt.emptyList();
    }

    public static <T> CopyOnWriteArrayList<T> createEmptyCOWList() {
        return ContainerUtilRt.createEmptyCOWList();
    }

    public static <T> List<T> createLockFreeCopyOnWriteList() {
        return ContainerUtil.createConcurrentList();
    }

    public static <T> List<T> createLockFreeCopyOnWriteList(Collection<? extends T> c) {
        return new LockFreeCopyOnWriteArrayList<T>(c);
    }

    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectMap() {
        return new ConcurrentIntObjectHashMap();
    }

    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectSoftValueMap() {
        return new ConcurrentSoftValueIntObjectHashMap();
    }

    public static <V> ConcurrentLongObjectMap<V> createConcurrentLongObjectMap() {
        return new ConcurrentLongObjectHashMap();
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakValueMap() {
        return new ConcurrentWeakValueHashMap();
    }

    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectWeakValueMap() {
        return new ConcurrentWeakValueIntObjectHashMap();
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, TObjectHashingStrategy<K> hashingStrategy) {
        return new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    /*
     * Exception decompiling
     */
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftValueMap() {
        return new ConcurrentSoftValueHashMap();
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap() {
        return new ConcurrentSoftHashMap();
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap() {
        return new ConcurrentWeakHashMap();
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(int initialCapacity, float loadFactor, int concurrencyLevel, TObjectHashingStrategy<K> hashingStrategy) {
        return new ConcurrentWeakHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    public static <T> ConcurrentList<T> createConcurrentList() {
        return new LockFreeCopyOnWriteArrayList();
    }

    public static <T> void addIfNotNull(T element, Collection<T> result) {
        ContainerUtilRt.addIfNotNull(element, result);
    }

    public static <T> void addIfNotNull(Collection<T> result, T element) {
        ContainerUtilRt.addIfNotNull(result, element);
    }

    public static <T, V> List<V> map2List(T[] array, Function<T, V> mapper) {
        return ContainerUtilRt.map2List(array, mapper);
    }

    public static <T, V> List<V> map2List(Collection<? extends T> collection, Function<T, V> mapper) {
        return ContainerUtilRt.map2List(collection, mapper);
    }

    public static <T, V> Set<V> map2Set(T[] collection, Function<T, V> mapper) {
        return ContainerUtilRt.map2Set(collection, mapper);
    }

    public static <T, V> Set<V> map2Set(Collection<? extends T> collection, Function<T, V> mapper) {
        return ContainerUtilRt.map2Set(collection, mapper);
    }

    public static <T, V> Set<V> map2SetNotNull(Collection<? extends T> collection, Function<T, V> mapper) {
        if (collection.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet set = new HashSet(collection.size());
        for (T t : collection) {
            V value = mapper.fun(t);
            if (value == null) continue;
            set.add(value);
        }
        return set.isEmpty() ? Collections.emptySet() : set;
    }

    public static <T> T[] toArray(List<T> collection, T[] array) {
        return ContainerUtilRt.toArray(collection, array);
    }

    public static <T> T[] toArray(Collection<T> c, T[] sample) {
        return ContainerUtilRt.toArray(c, sample);
    }

    public static <T> T[] copyAndClear(Collection<T> collection, ArrayFactory<T> factory, boolean clear) {
        int size = collection.size();
        T[] a = factory.create(size);
        if (size > 0) {
            a = collection.toArray(a);
            if (clear) {
                collection.clear();
            }
        }
        return a;
    }

    public static <T> Collection<T> toCollection(Iterable<T> iterable) {
        return iterable instanceof Collection ? (ArrayList<T>)iterable : ContainerUtil.newArrayList(iterable);
    }

    public static <T> List<T> toList(Enumeration<T> enumeration) {
        if (!enumeration.hasMoreElements()) {
            return Collections.emptyList();
        }
        SmartList<T> result = new SmartList<T>();
        while (enumeration.hasMoreElements()) {
            result.add(enumeration.nextElement());
        }
        return result;
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> List<T> notNullize(List<T> list) {
        return list == null ? ContainerUtilRt.emptyList() : list;
    }

    public static <T> Set<T> notNullize(Set<T> set) {
        return set == null ? Collections.emptySet() : set;
    }

    public static <T, C extends Collection<T>> C nullize(C collection) {
        return ContainerUtil.isEmpty(collection) ? null : (C)collection;
    }

    private static boolean isAtLeastJava7() {
        return StringUtil.compareVersionNumbers(SystemInfo.JAVA_VERSION, "1.7") >= 0;
    }

    public static <T extends Comparable<T>> int compareLexicographically(List<T> o1, List<T> o2) {
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int result = Comparing.compare((Comparable)o1.get(i), (Comparable)o2.get(i));
            if (result == 0) continue;
            return result;
        }
        return o1.size() < o2.size() ? -1 : (o1.size() == o2.size() ? 0 : 1);
    }

    public static <T> int compareLexicographically(List<T> o1, List<T> o2, Comparator<T> comparator) {
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int result = comparator.compare(o1.get(i), o2.get(i));
            if (result == 0) continue;
            return result;
        }
        return o1.size() < o2.size() ? -1 : (o1.size() == o2.size() ? 0 : 1);
    }

    public static String toString(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry = iterator.next();
            sb.append(entry.getKey()).append('=').append(entry.getValue());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    private static interface ConcurrentMapFactory {
        public <T, V> ConcurrentMap<T, V> createMap();

        public <T, V> ConcurrentMap<T, V> createMap(int var1);

        public <T, V> ConcurrentMap<T, V> createMap(TObjectHashingStrategy<T> var1);

        public <T, V> ConcurrentMap<T, V> createMap(int var1, float var2, int var3);

        public <T, V> ConcurrentMap<T, V> createMap(int var1, float var2, int var3, TObjectHashingStrategy<T> var4);
    }

    private static class ImmutableListBackedByArray<E>
    extends ImmutableList<E> {
        private final E[] myStore;

        private ImmutableListBackedByArray(E[] array) {
            this.myStore = array;
        }

        @Override
        public E get(int index) {
            return this.myStore[index];
        }

        @Override
        public int size() {
            return this.myStore.length;
        }
    }

    private static class ImmutableListBackedByList<E>
    extends ImmutableList<E> {
        private final List<E> myStore;

        private ImmutableListBackedByList(List<E> list) {
            this.myStore = list;
        }

        @Override
        public E get(int index) {
            return this.myStore.get(index);
        }

        @Override
        public int size() {
            return this.myStore.size();
        }
    }

    public static class ImmutableMapBuilder<K, V> {
        private final Map<K, V> myMap = new THashMap();

        public ImmutableMapBuilder<K, V> put(K key, V value) {
            this.myMap.put(key, value);
            return this;
        }

        public Map<K, V> build() {
            return Collections.unmodifiableMap(this.myMap);
        }
    }
}

