/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MostlySingularMultiMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 2784448345881807109L;
    protected final Map<K, Object> myMap = this.createMap();
    private static final MostlySingularMultiMap EMPTY = new EmptyMap();

    protected Map<K, Object> createMap() {
        return new THashMap();
    }

    public void add(K key, V value) {
        Object current = this.myMap.get(key);
        if (current == null) {
            this.myMap.put(key, value);
        } else if (current instanceof Object[]) {
            Object[] curArr = (Object[])current;
            Object[] newArr = ArrayUtil.append(curArr, value, ArrayUtil.OBJECT_ARRAY_FACTORY);
            this.myMap.put(key, newArr);
        } else {
            this.myMap.put(key, new Object[]{current, value});
        }
    }

    public boolean remove(K key, V value) {
        Object current = this.myMap.get(key);
        if (current == null) {
            return false;
        }
        if (current instanceof Object[]) {
            Object[] curArr = (Object[])current;
            Object[] newArr = ArrayUtil.remove(curArr, value, ArrayUtil.OBJECT_ARRAY_FACTORY);
            this.myMap.put(key, newArr);
            return newArr.length == curArr.length - 1;
        }
        if (value.equals(current)) {
            this.myMap.remove(key);
            return true;
        }
        return false;
    }

    public boolean removeAllValues(K key) {
        return this.myMap.remove(key) != null;
    }

    public Set<K> keySet() {
        return this.myMap.keySet();
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    public boolean processForKey(K key, Processor<? super V> p) {
        return this.processValue(p, this.myMap.get(key));
    }

    private boolean processValue(Processor<? super V> p, Object v) {
        if (v instanceof Object[]) {
            for (Object o : (Object[])v) {
                if (p.process(o)) continue;
                return false;
            }
        } else if (v != null) {
            return p.process(v);
        }
        return true;
    }

    public boolean processAllValues(Processor<? super V> p) {
        for (Object v : this.myMap.values()) {
            if (this.processValue(p, v)) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.myMap.size();
    }

    public boolean containsKey(K key) {
        return this.myMap.containsKey(key);
    }

    public int valuesForKey(K key) {
        Object current = this.myMap.get(key);
        if (current == null) {
            return 0;
        }
        if (current instanceof Object[]) {
            return ((Object[])current).length;
        }
        return 1;
    }

    public Iterable<V> get(K name) {
        Object value = this.myMap.get(name);
        return this.rawValueToCollection(value);
    }

    protected List<V> rawValueToCollection(Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        return Collections.singletonList(value);
    }

    public void compact() {
        ((THashMap)this.myMap).compact();
    }

    public String toString() {
        return "{" + StringUtil.join(this.myMap.entrySet(), new Function<Map.Entry<K, Object>, String>(){

            @Override
            public String fun(Map.Entry<K, Object> entry) {
                Object value = entry.getValue();
                String s = (value instanceof Object[] ? Arrays.asList((Object[])value) : Arrays.asList(value)).toString();
                return entry.getKey() + ": " + s;
            }
        }, "; ") + "}";
    }

    public void clear() {
        this.myMap.clear();
    }

    public static <K, V> MostlySingularMultiMap<K, V> emptyMap() {
        return EMPTY;
    }

    public static <K, V> MostlySingularMultiMap<K, V> newMap() {
        return new MostlySingularMultiMap<K, V>();
    }

    private static class EmptyMap
    extends MostlySingularMultiMap {
        private EmptyMap() {
        }

        public void add(Object key, Object value) {
            throw new IncorrectOperationException();
        }

        public boolean remove(Object key, Object value) {
            throw new IncorrectOperationException();
        }

        public boolean removeAllValues(Object key) {
            throw new IncorrectOperationException();
        }

        @Override
        public void clear() {
            throw new IncorrectOperationException();
        }

        public Set keySet() {
            return Collections.emptySet();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public boolean processForKey(Object key, Processor p) {
            return true;
        }

        public boolean processAllValues(Processor p) {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        public int valuesForKey(Object key) {
            return 0;
        }

        public Iterable get(Object name) {
            return ContainerUtil.emptyList();
        }
    }
}

