/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

abstract class RefHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final MyMap myMap;
    private final ReferenceQueue<K> myReferenceQueue = new ReferenceQueue();
    private final HardKey<K> myHardKeyInstance = new HardKey();
    private Set<Map.Entry<K, V>> entrySet = null;
    private boolean processingQueue;

    public RefHashMap(int initialCapacity, float loadFactor, TObjectHashingStrategy<Key<K>> strategy) {
        this.myMap = new MyMap(initialCapacity, loadFactor, strategy);
    }

    public RefHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, ContainerUtil.canonicalStrategy());
    }

    public RefHashMap(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    public RefHashMap() {
        this(4);
    }

    public RefHashMap(Map<K, V> t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    public RefHashMap(final TObjectHashingStrategy<K> hashingStrategy) {
        this(4, 0.8f, new TObjectHashingStrategy<Key<K>>(){

            public int computeHashCode(Key<K> object) {
                return hashingStrategy.computeHashCode(object.get());
            }

            public boolean equals(Key<K> o1, Key<K> o2) {
                return hashingStrategy.equals(o1.get(), o2.get());
            }
        });
    }

    protected abstract <T> Key<T> createKey(T var1, ReferenceQueue<? super T> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processQueue() {
        boolean processed = false;
        try {
            Key wk;
            this.processingQueue = true;
            while ((wk = (Key)((Object)this.myReferenceQueue.poll())) != null) {
                this.myMap.remove(wk);
                processed = true;
            }
        }
        finally {
            this.processingQueue = false;
        }
        this.myMap.compactIfNecessary();
        return processed;
    }

    V removeKey(Key<K> key) {
        return (V)this.myMap.remove(key);
    }

    Key<K> createKey(K key) {
        return this.createKey(key, this.myReferenceQueue);
    }

    V putKey(Key<K> weakKey, V value) {
        return (V)this.myMap.put(weakKey, value);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        ((HardKey)this.myHardKeyInstance).set(key);
        boolean result = this.myMap.containsKey(this.myHardKeyInstance);
        ((HardKey)this.myHardKeyInstance).clear();
        return result;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return null;
        }
        ((HardKey)this.myHardKeyInstance).set(key);
        Object result = this.myMap.get(this.myHardKeyInstance);
        ((HardKey)this.myHardKeyInstance).clear();
        return (V)result;
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        return this.putKey(this.createKey(key), value);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        ((HardKey)this.myHardKeyInstance).set(key);
        Object result = this.myMap.remove(this.myHardKeyInstance);
        ((HardKey)this.myHardKeyInstance).clear();
        return (V)result;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myMap.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<Key<K>, V>> hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = RefHashMap.this.myMap.entrySet();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private final Iterator<Map.Entry<Key<K>, V>> hashIterator;
                private MyEntry<K, V> next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                    this.next = null;
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        Key wk = ent.getKey();
                        Object k = null;
                        if (wk != null) {
                            Object k2 = wk.get();
                            k = k2;
                            if (k2 == null) continue;
                        }
                        this.next = new MyEntry(ent, k);
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    MyEntry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        @Override
        public boolean remove(Object o) {
            boolean toRemove;
            RefHashMap.this.processQueue();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ev = e.getValue();
            RefHashMap.this.myHardKeyInstance.set(e.getKey());
            HardKey key = RefHashMap.this.myHardKeyInstance;
            Object hv = RefHashMap.this.myMap.get(key);
            boolean bl = hv == null ? ev == null && RefHashMap.this.myMap.containsKey(key) : (toRemove = hv.equals(ev));
            if (toRemove) {
                RefHashMap.this.myMap.remove(key);
            }
            RefHashMap.this.myHardKeyInstance.clear();
            return toRemove;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry entry : this.hashEntrySet) {
                Object v;
                Key wk = entry.getKey();
                if (wk == null) continue;
                h += wk.hashCode() ^ ((v = entry.getValue()) == null ? 0 : v.hashCode());
            }
            return h;
        }
    }

    private static class MyEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<?, V> ent;
        private final K key;

        private MyEntry(Map.Entry<?, V> ent, K key) {
            this.ent = ent;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.ent.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.ent.setValue(value);
        }

        private static boolean valEquals(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return MyEntry.valEquals(this.key, e.getKey()) && MyEntry.valEquals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            V v = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }
    }

    private static class HardKey<T>
    implements Key<T> {
        private T myObject;
        private int myHash;

        private HardKey() {
        }

        @Override
        public T get() {
            return this.myObject;
        }

        private void set(T object) {
            this.myObject = object;
            this.myHash = object.hashCode();
        }

        private void clear() {
            this.myObject = null;
            this.myHash = 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            T t = this.myObject;
            Object u = ((Key)o).get();
            return t == u || t.equals(u);
        }

        public int hashCode() {
            return this.myHash;
        }
    }

    static interface Key<T> {
        public T get();
    }

    private class MyMap
    extends THashMap<Key<K>, V> {
        private MyMap(int initialCapacity, float loadFactor, TObjectHashingStrategy<Key<K>> strategy) {
            super(initialCapacity, loadFactor, strategy);
        }

        public void compact() {
            if (!RefHashMap.this.processingQueue) {
                super.compact();
            }
        }

        private void compactIfNecessary() {
            if (this._deadkeys > this._size && this.capacity() > 42) {
                this.compact();
            }
        }

        protected void rehash(int newCapacity) {
            int oldCapacity = this._set.length;
            Object[] oldKeys = this._set;
            Object[] oldVals = this._values;
            this._set = new Object[newCapacity];
            this._values = new Object[newCapacity];
            int i = oldCapacity;
            while (i-- > 0) {
                Key k;
                Object key;
                Object o = oldKeys[i];
                if (o == null || o == REMOVED || (key = (k = (Key)o).get()) == null) continue;
                int index = this.insertionIndex(k);
                if (index < 0) {
                    this.throwObjectContractViolation(this._set[-index - 1], o + "; key: " + key);
                }
                this._set[index] = o;
                this._values[index] = oldVals[i];
            }
        }
    }
}

