/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class WeakInterner<T> {
    private final ConcurrentMap<T, T> myMap = ContainerUtil.createConcurrentWeakKeyWeakValueMap();

    public T intern(T name) {
        return ConcurrencyUtil.cacheOrGet(this.myMap, name, name);
    }

    public void clear() {
        this.myMap.clear();
    }

    public Set<T> getValues() {
        return ContainerUtil.newTroveSet(this.myMap.values());
    }
}

