/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.containers.RefHashMap;
import com.intellij.util.containers.WeakHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public final class WeakKeyWeakValueHashMap<K, V>
implements Map<K, V> {
    private final WeakHashMap<K, ValueReference<K, V>> myWeakKeyMap = new WeakHashMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    boolean processQueue() {
        ValueReference ref;
        boolean processed = this.myWeakKeyMap.processQueue();
        while ((ref = (ValueReference)this.myQueue.poll()) != null) {
            RefHashMap.Key weakKey = ref.key;
            this.myWeakKeyMap.removeKey(weakKey);
            processed = true;
        }
        return processed;
    }

    @Override
    public V get(Object key) {
        ValueReference ref = (ValueReference)this.myWeakKeyMap.get(key);
        return (V)SoftReference.dereference(ref);
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        RefHashMap.Key<K> weakKey = this.myWeakKeyMap.createKey(key);
        ValueReference reference = new ValueReference(weakKey, value, this.myQueue);
        ValueReference oldRef = this.myWeakKeyMap.putKey(weakKey, reference);
        return (V)SoftReference.dereference(oldRef);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        ValueReference ref = (ValueReference)this.myWeakKeyMap.remove(key);
        return (V)SoftReference.dereference(ref);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new RuntimeException("method not implemented");
    }

    @Override
    public void clear() {
        this.myWeakKeyMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        return this.myWeakKeyMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myWeakKeyMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new RuntimeException("method not implemented");
    }

    @Override
    public Set<K> keySet() {
        return this.myWeakKeyMap.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList result = new ArrayList();
        Collection refs = this.myWeakKeyMap.values();
        for (ValueReference ref : refs) {
            Object value = ref.get();
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new RuntimeException("method not implemented");
    }

    private static class ValueReference<K, V>
    extends WeakReference<V> {
        private final RefHashMap.Key<K> key;

        private ValueReference(RefHashMap.Key<K> key, V referent, ReferenceQueue<? super V> q) {
            super(referent, q);
            this.key = key;
        }
    }
}

