/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers.hash;

import gnu.trove.TObjectHashingStrategy;

public interface EqualityPolicy<T> {
    public static final EqualityPolicy<?> IDENTITY = new EqualityPolicy(){

        public int getHashCode(Object value) {
            return System.identityHashCode(value);
        }

        public boolean isEqual(Object val1, Object val2) {
            return val1 == val2;
        }
    };
    public static final EqualityPolicy<?> CANONICAL = new EqualityPolicy(){

        public int getHashCode(Object value) {
            return value != null ? value.hashCode() : 0;
        }

        public boolean isEqual(Object val1, Object val2) {
            return val1 != null ? val1.equals(val2) : val2 == null;
        }
    };

    public int getHashCode(T var1);

    public boolean isEqual(T var1, T var2);

    public static class ByHashingStrategy<T>
    implements EqualityPolicy<T> {
        private final TObjectHashingStrategy<T> myStrategy;

        public ByHashingStrategy(TObjectHashingStrategy<T> strategy) {
            this.myStrategy = strategy;
        }

        @Override
        public int getHashCode(T value) {
            return this.myStrategy.computeHashCode(value);
        }

        @Override
        public boolean isEqual(T val1, T val2) {
            return this.myStrategy.equals(val1, val2);
        }
    }
}

